package com.yyjz.icop.pub.base.dao;

import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import org.hibernate.SQLQuery;
import org.hibernate.transform.AliasToBeanConstructorResultTransformer;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.Transformers;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

/**
 * 基础DAO类，可以直接传入SQL语句，用于复杂SQL查询
 *
 * @author zhaowhf
 * @time 2016年7月18日18:25:23
 */
@Repository
public class BaseQueryDao {

//	private EntityManager entityManager;

	@PersistenceContext
	private EntityManager em;

	public BaseQueryDao() {
		super();
	}

    public BaseQueryDao(EntityManager entityManager) {
        super();
//        this.entityManager = entityManager;
    }
//
//    public EntityManager getEntityManager() {
//        return entityManager;
//    }
//
//    public void setEntityManager(EntityManager entityManager) {
//        this.entityManager = entityManager;
//    }

    /**
     * 按顺序设置Query参数
     *
     * @param query
     * @param paras
     */
    private void setParameters(Query query, Map<String, Object> paras) {
        if (paras == null || paras.isEmpty()) {
            return;
        }
        Set<String> set = paras.keySet();
        for (String key : set) {
            query.setParameter(key, paras.get(key));
        }
    }

    /**
     * 按顺序设置Query参数
     *
     * @param query
     * @param paras
     */
    private void setParameters(Query query, List<Object> paras) {
        if (paras == null || paras.isEmpty()) {
            return;
        }
        for (int i = 0; i < paras.size(); i++) {
            query.setParameter(i, paras.get(i));
        }
    }

    /**
     * 根据SQL语句获取一条记录
     *
     * @param sql
     * @param paras
     * @return
     */
    public Object findOneBySql(String sql, List<Object> paras) {
        Query query = em.createNativeQuery(sql);
        setParameters(query, paras);
        return query.getSingleResult();
    }

	public <T> Object findOneBySql(String sql, List<Object> paras, Class<T> clazz) {
        Query query = em.createNativeQuery(sql);
        setParameters(query, paras);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.aliasToBean(clazz));
        return query.getSingleResult();
	}

	/**
	 * 根据SQL语句查询列表
	 *
	 * @param sql
	 *            已拼装好的SQL语句
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public List<Object> findListBySql(String sql) {
		Query rquery = em.createNativeQuery(sql);
		return rquery.getResultList();
	}

        /**
         * 根据SQL语句查询列表
         *
         * @param sql      已拼装好带"?"的SQL语句
         * @param paras    参数
         * @param offset   起始查询号
         * @param pageSize 分页大小
         * @return
         */
    @SuppressWarnings("unchecked")
    public List<Object> findListBySql(String sql, Map<String, Object> paras, int offset, int pageSize) {
        Query rquery = em.createNativeQuery(sql);
        setParameters(rquery, paras);
        rquery.setFirstResult(offset);
        rquery.setMaxResults(pageSize);
        return rquery.getResultList();
    }

    /**
     * 根据SQL语句查询列表
     *
     * @param sql      已拼装好带"?"的SQL语句
     * @param paras    参数
     * @param offset   起始查询号
     * @param pageSize 分页大小
     * @return
     */
    @SuppressWarnings("unchecked")
    public List<Object> findListBySql(String sql, List<Object> paras, int offset, int pageSize) {
        Query rquery = em.createNativeQuery(sql);
        setParameters(rquery, paras);
        rquery.setFirstResult(offset);
        rquery.setMaxResults(pageSize);
        return rquery.getResultList();
    }

    /**
     * 根据SQL语句查询列表
     *
     * @param sql
     * @param paras
     * @return
     */
    @SuppressWarnings("unchecked")
    public List<Object> findListBySql(String sql, Map<String, Object> paras) {
        Query rquery = em.createNativeQuery(sql);
        setParameters(rquery, paras);
        return rquery.getResultList();
    }

    /**
     * 根据SQL语句查询分页记录
     *
     * @param sql           已拼装好"?"的SQL语句
     * @param paras
     * @param pageable
     * @param
     * @return
     */
    public Page<Object> findListBySql(String sql, Map<String, Object> paras, Pageable pageable) {
        if (pageable == null) {
            return new PageImpl<Object>(findListBySql(sql, paras));
        }
        String csql = "select count(1) from (" + sql + ") t";
        return findListBySql(sql, csql, paras, pageable);
    }

    /**
     * 根据SQL语句查询分页记录
     *
     * @param qsql     用于查询返回记录的SQL语句
     * @param csql     用于查询记录条数的SQL语句
     * @param paras
     * @param pageable
     * @return
     */
    @SuppressWarnings("unchecked")
    public Page<Object> findListBySql(String qsql, String csql, Map<String, Object> paras, Pageable pageable) {
        if (pageable == null) {
            return new PageImpl<Object>(findListBySql(qsql, paras));
        }
        Query rquery = em.createNativeQuery(qsql);
        Query cquery = em.createNativeQuery(csql);
        setParameters(rquery, paras);
        setParameters(cquery, paras);

        rquery.setFirstResult(pageable.getOffset());
        rquery.setMaxResults(pageable.getPageSize());

        List<Object> list = rquery.getResultList();
        long total = ((BigInteger) cquery.getSingleResult()).longValue();

        return new PageImpl<Object>(list, pageable, total);
    }

    /**
     * 根据SQL语句查询列表
     *
     * @param sql
     * @param paras
     * @return
     */
    @SuppressWarnings("unchecked")
    public List<Object> findListBySql(String sql, List<Object> paras) {
        Query rquery = em.createNativeQuery(sql);
        setParameters(rquery, paras);
        return rquery.getResultList();
    }

    /**
     * 根据SQL语句查询分页记录
     *
     * @param sql      已拼装好"?"的SQL语句
     * @param paras
     * @param pageable
     * @return
     */
    public Page<Object> findListBySql(String sql, List<Object> paras, Pageable pageable) {
        if (pageable == null) {
            return new PageImpl<Object>(findListBySql(sql, paras));
        }
        String csql = "select count(1) from (" + sql + ") t";
        return findListBySql(sql, csql, paras, pageable);
    }

    /**
     * 根据SQL查询SQL语句
     *
     * @param qsql
     * @param csql
     * @param paras
     * @param pageable
     * @return
     */
    @SuppressWarnings("unchecked")
    public Page<Object> findListBySql(String qsql, String csql, List<Object> paras, Pageable pageable) {
        if (pageable == null) {
            return new PageImpl<Object>(findListBySql(qsql, paras));
        }
        Query rquery = em.createNativeQuery(qsql);
        Query cquery = em.createNativeQuery(csql);
        setParameters(rquery, paras);
        setParameters(cquery, paras);

        rquery.setFirstResult(pageable.getOffset());
        rquery.setMaxResults(pageable.getPageSize());

        List<Object> list = rquery.getResultList();
        long total = ((BigInteger) cquery.getSingleResult()).longValue();

        return new PageImpl<Object>(list, pageable, total);
    }

    public <T> Page<T> findPageBySql(String sql, Map<String, Object> params, Pageable pageable, Class<T> c) {
        Query query = em.createNativeQuery(sql);
        setParameters(query, params);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.aliasToBean(c));

        long total = 0;
        if (pageable != null) {
            query.setFirstResult(pageable.getOffset());
            query.setMaxResults(pageable.getPageSize());

            String countSql = "select count(0) from (" + sql + ") t";
            Query countQuery = em.createNativeQuery(countSql);
            setParameters(countQuery, params);
            total = ((BigInteger) countQuery.getSingleResult()).longValue();
        }

        @SuppressWarnings("unchecked")
        List<T> content = query.getResultList();
        return new PageImpl<>(content, pageable, pageable != null ? total : content.size());
    }
    
    /**
     * 查询结果为List<Map>
     * @param sql
     * @param params
     * @param pageable
     * @return
     */
    @SuppressWarnings({ "rawtypes", "unchecked" })
	public Page<Map> findPageMapBySql(String sql, Map<String, Object> params, Pageable pageable) {
    	Query query = em.createNativeQuery(sql);
    	query.unwrap(SQLQuery.class).setResultTransformer(AliasToEntityMapResultTransformer.INSTANCE);
    	setParameters(query, params);
    	long total = 0;
    	if (pageable != null) {
    		query.setFirstResult(pageable.getOffset());
    		query.setMaxResults(pageable.getPageSize());
    		String countSql = "select count(0) from (" + sql + ") t";
    		Query countQuery = em.createNativeQuery(countSql);
    		setParameters(countQuery, params);
    		total = ((BigInteger) countQuery.getSingleResult()).longValue();
    	}
    	List<Map> content = query.getResultList();
    	return new PageImpl<Map>(content, pageable, pageable != null ? total : content.size());
    }
    
    /**
     * 查询结果为List<Bean>
     * @param <T>
     * @param sql
     * @param params
     * @param pageable
     * @return
     */
    @SuppressWarnings("unchecked")
	public <T> Page<T> findPageEntityBySql(String sql, Map<String, Object> params, Pageable pageable, Constructor<T> cons) {
    	Query query = em.createNativeQuery(sql);
    	query.unwrap(SQLQuery.class).setResultTransformer(new AliasToBeanConstructorResultTransformer(cons));
    	setParameters(query, params);
    	long total = 0;
    	if (pageable != null) {
    		query.setFirstResult(pageable.getOffset());
    		query.setMaxResults(pageable.getPageSize());
    		String countSql = "select count(0) from (" + sql + ") t";
    		Query countQuery = em.createNativeQuery(countSql);
    		setParameters(countQuery, params);
    		total = ((BigInteger) countQuery.getSingleResult()).longValue();
    	}
    	List<T> content = query.getResultList();
    	return new PageImpl<T>(content, pageable, pageable != null ? total : content.size());
    }

    @SuppressWarnings({ "unchecked", "rawtypes" })
	public <T> Page<T> findPageBySql(String sql, List params, Pageable pageable, Class<T> c) {
        Query query = em.createNativeQuery(sql);
        //noinspection unchecked
        setParameters(query, params);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.aliasToBean(c));

        long total = 0;
        if (pageable != null) {
            query.setFirstResult(pageable.getOffset());
            query.setMaxResults(pageable.getPageSize());

            String countSql = "select count(*) from (" + sql + ") t";
            Query countQuery = em.createNativeQuery(countSql);
            setParameters(countQuery, params);
            total = ((BigInteger) countQuery.getSingleResult()).longValue();
        }

       
        List<T> content = query.getResultList();
        return new PageImpl<>(content, pageable, pageable != null ? total : content.size());
    }

    @SuppressWarnings("unchecked")
	public <T> List<T> findListBySql(String hql, Map<String, Object> params, Class<T> c) {
        Query query = em.createNativeQuery(hql);
        setParameters(query, params);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.aliasToBean(c));

        //noinspection unchecked
        return query.getResultList();
    }

    @SuppressWarnings({ "rawtypes", "unchecked" })
	public <T> List<T> findListBySql(String sql, List params, Class<T> c) {
        Query query = em.createNativeQuery(sql);
        //noinspection unchecked
        setParameters(query, params);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.aliasToBean(c));

        //noinspection unchecked
        return query.getResultList();
    }

    @SuppressWarnings({ "rawtypes", "unchecked" })
	public List<Map<String, Object>> findMapBySql(String sql, List params) {
        Query query = em.createNativeQuery(sql);
        //noinspection unchecked
        setParameters(query, params);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);

        //noinspection unchecked
        return query.getResultList();
	}
    
    @SuppressWarnings({ "unchecked", "rawtypes" })
	public List<Map<String, Object>> findMapBySql(String sql, Map params) {
    	Query query = em.createNativeQuery(sql);
    	//noinspection unchecked
    	setParameters(query, params);
    	query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
    	
    	//noinspection unchecked
    	return query.getResultList();
    }

	public void executeUpdateSQL(String sql) throws Exception {
		em.createNativeQuery(sql).executeUpdate();
	}
}
