package com.yyjz.icop.pub.base.dao.impl;

import java.io.Serializable;
import java.sql.Timestamp;

import javax.persistence.EntityManager;

import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import com.yyjz.icop.pub.base.dao.BaseDao;
import com.yyjz.icop.pub.base.entity.BaseIdEntity;
import com.yyjz.icop.pub.base.entity.SuperBillMainEntity;
import com.yyjz.icop.pub.base.exception.TimestampOutOfDateException;

@Transactional
public class BaseDaoImpl<T extends BaseIdEntity> extends SimpleJpaRepository<T, Serializable> implements BaseDao<T> {

    private final EntityManager entityManager;
    
    public BaseDaoImpl(Class<T> domainClass, EntityManager entityManager) {
        super(domainClass, entityManager);
        this.entityManager = entityManager;
    }

    public BaseDaoImpl(JpaEntityInformation<T, Serializable> information, EntityManager entityManager){
    	super(information, entityManager);
    	this.entityManager = entityManager;
	}

	@Override
	public <S extends T> S save(S entity) {
		// id不为空的时候为更新操作，更新操作要校验ts，确定此条数据没有被修改过
		if (!StringUtils.isEmpty(entity.getId())) {
			// 获取此条数据的ts
			Timestamp pretime = entity.getTs();
			// 获取此条数据在库中的ts
			Timestamp curtime = findOne(entity.getId()).getTs();
			// 比较ts，若此数据已被更改
			if (curtime.after(pretime))	
				throw new TimestampOutOfDateException();
		}
		if (entity instanceof SuperBillMainEntity) {
			((SuperBillMainEntity) entity).setModifytime(new Timestamp(System.currentTimeMillis()));
		}
		return super.save(entity);
	}

	/**
     * 只做逻辑删除
     */
	@Override
	public void delete(T entity) {
		entity.setDr(1);
		save(entity);
	}

	@Override
	public void delete(Serializable id) {
		T entity = findOne(id);
		entity.setDr(1);
		this.save(entity);
	}

	
}
