package com.yyjz.icop.pub.base.entity;

import java.io.Serializable;
import java.sql.Timestamp;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

import org.hibernate.annotations.GenericGenerator;

import com.yyjz.icop.database.entity.SuperEntity;

/**
 * JPA 基类.
 * <p>
 * &nbsp;&nbsp;&nbsp;&nbsp;统一定义id的entity基类.<br>
 * </p>
 *
 * @author zhaowhfs
 * @time 2016年7月18日18:25:23
 */
@MappedSuperclass
public abstract class BaseIdEntity extends SuperEntity implements Serializable {

	private static final long serialVersionUID = -8331905202804631873L;

	/** 实体主键 */
	@Id
	@GeneratedValue(generator = "system-uuid")
	@GenericGenerator(name = "system-uuid", strategy = "uuid")
	@Column(name = "ID", unique = true, nullable = false, length = 32)
	protected String id;

	/** 时间戳，用于同步锁 */
	protected Timestamp ts = new Timestamp(System.currentTimeMillis());

	public String getId() {
		return id;
	}

	public void setId(String id) {
		if (id != null && id == "") {
			this.id = null;
		} else {
			this.id = id;
		}
	}

	public Timestamp getTs() {
		return ts;
	}

	public void setTs(Timestamp ts) {
		this.ts = ts;
	}

}
