package com.yyjz.icop.pub.base.entity;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 主表实体基类，所有业务实体主表继承此类
 *
 * @author zhaowhf
 * @time 2016年7月18日18:25:23
 */
@MappedSuperclass
public abstract class SuperBillMainEntity extends BaseIdEntity {

	private static final long serialVersionUID = -8099135996907557344L;

	/** 单据编号 */
	@Column(name = "bill_code")
	private String billCode;

	/** 单据类型 */
	@Column(name = "bill_type")
	private String billType;

	/** 单据状态 */
	@Column(name = "bill_state")
	private int billState;

	/** 单据日期 */
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
	@Column(name = "bill_date")
	private Date billDate;

	/** 流程实例id */
	private String bpmid;

	/** 备注 */
	private String memo;

	/** 单据来源id */
	@Column(name = "bill_source_id")
	private String billSourceId;

	/** 来源单据类型 */
	@Column(name = "source_bill_type")
	private String sourceBillType;

	/** 创建人id */
	private String creatorid;

	/** 创建人 */
	private String creator;

	/** 创建时间 */
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
	private Date createtime;

	/** 修改人id */
	private String modifierid;

	/** 修改人 */
	private String modifier;

	/**
	 * 修改时间,记录修改的最后时间.
	 */
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
	private Date modifytime;

	/** 审核人id */
	private String reviewerid;

	/** 审核人 */
	private String reviewer;

	/** 审核时间 */
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
	private Date reviewtime;

	/** 租户id */
	private String tenantid;

	/** 公司id */
	@Column(name = "company_id")
	private String companyId;

	public String getBillCode() {
		return billCode;
	}

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public String getBillType() {
		return billType;
	}

	public void setBillType(String billType) {
		this.billType = billType;
	}

	public int getBillState() {
		return billState;
	}

	public void setBillState(int billState) {
		this.billState = billState;
	}

	public Date getBillDate() {
		return billDate;
	}

	public void setBillDate(Date billDate) {
		this.billDate = billDate;
	}

	public String getBpmid() {
		return bpmid;
	}

	public void setBpmid(String bpmid) {
		this.bpmid = bpmid;
	}

	public String getMemo() {
		return memo;
	}

	public void setMemo(String memo) {
		this.memo = memo;
	}

	public String getBillSourceId() {
		return billSourceId;
	}

	public void setBillSourceId(String billSourceId) {
		this.billSourceId = billSourceId;
	}

	public String getSourceBillType() {
		return sourceBillType;
	}

	public void setSourceBillType(String sourceBillType) {
		this.sourceBillType = sourceBillType;
	}

	public String getCreatorid() {
		return creatorid;
	}

	public void setCreatorid(String creatorid) {
		this.creatorid = creatorid;
	}

	public String getCreator() {
		return creator;
	}

	public void setCreator(String creator) {
		this.creator = creator;
	}

	public Date getCreatetime() {
		return createtime;
	}

	public void setCreatetime(Date createtime) {
		this.createtime = createtime;
	}

	public String getModifierid() {
		return modifierid;
	}

	public void setModifierid(String modifierid) {
		this.modifierid = modifierid;
	}

	public String getModifier() {
		return modifier;
	}

	public void setModifier(String modifier) {
		this.modifier = modifier;
	}

	public Date getModifytime() {
		return modifytime;
	}

	public void setModifytime(Date modifytime) {
		this.modifytime = modifytime;
	}

	public String getReviewerid() {
		return reviewerid;
	}

	public void setReviewerid(String reviewerid) {
		this.reviewerid = reviewerid;
	}

	public String getReviewer() {
		return reviewer;
	}

	public void setReviewer(String reviewer) {
		this.reviewer = reviewer;
	}

	public Date getReviewtime() {
		return reviewtime;
	}

	public void setReviewtime(Date reviewtime) {
		this.reviewtime = reviewtime;
	}

	public String getTenantid() {
		return tenantid;
	}

	public void setTenantid(String tenantid) {
		this.tenantid = tenantid;
	}

	public String getCompanyId() {
		return companyId;
	}

	public void setCompanyId(String companyId) {
		this.companyId = companyId;
	}

}
