package com.yyjz.icop.pub.base.entity;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;

/**
 * 子表实体基类，所有业务实体子表继承此类
 *
 * @author zhaowhf
 * @time 2016年7月18日18:25:23
 */
@MappedSuperclass
public abstract class SuperBillSubEntity extends BaseIdEntity {

	private static final long serialVersionUID = 2429271231510204947L;

	/** 单据来源id */
	@Column(name = "bill_source_id")
	private String billSourceId;

	/** 单据来源子表id */
	@Column(name = "bill_source_sub_id")
	private String billSourceSubId;

	/** 备注 */
	private String memo;

	public String getBillSourceId() {
		return billSourceId;
	}

	public void setBillSourceId(String billSourceId) {
		this.billSourceId = billSourceId;
	}

	public String getBillSourceSubId() {
		return billSourceSubId;
	}

	public void setBillSourceSubId(String billSourceSubId) {
		this.billSourceSubId = billSourceSubId;
	}

	public String getMemo() {
		return memo;
	}

	public void setMemo(String memo) {
		this.memo = memo;
	}
}
