package com.yyjz.icop.pub.base.service;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.yyjz.icop.pub.base.entity.BaseIdEntity;
import com.yyjz.icop.pub.base.vo.BpmStateVO;
import com.yyjz.icop.pub.base.vo.SuperVO;

/**
 * 所有Service基类 ，业务模块service接口需要继承此接口
 *
 * @author zhaowhf
 * @time 2016年7月18日18:25:23
 */
public interface IBaseService<E extends BaseIdEntity, V extends SuperVO> {

	/**
	 * 保存，入参VO，返回VO
	 */
	V save(V vo, Class<E> clazzE, Class<V> clazzV) throws Exception;

	/**
	 * 保存，入参Entity，返回VO
	 */
	V saveEntityReturnVO(E entity, Class<E> clazzE, Class<V> clazzV) throws Exception;

	/**
	 * 保存，入参Entity，返回Entity
	 */
	E saveEntity(E entity, Class<E> clazzE, Class<V> clazzV) throws Exception;

	/**
	 * 批量保存
	 */
	void saveBatch(List<V> vos, Class<E> clazzE, Class<V> clazzV) throws Exception;

	/**
	 * 按vo删除
	 */
	void delete(V t) throws Exception;

	/**
	 * 按id删除
	 */
	void delete(String id) throws Exception;

	/**
	 * 按id批量删除
	 */
	void deleteBatch(String[] ids) throws Exception;

	/**
	 * 按vo批量删除
	 */
	void deleteBatch(List<V> vos) throws Exception;

	/**
	 * 根据条件查询，返回vo集合
	 */
	List<V> findByCondition(final Map<String, Object> searchParams, Class<V> clazzV, Class<E> clazzE) throws Exception;

	/**
	 * 根据id查询vo
	 */
	public V findVOById(String id, Class<V> cls) throws Exception;

	/**
	 * 根据id查询Entity
	 */
	E findEntityById(String id, Class<E> cls) throws Exception;

	/**
	 * 分页，返回vo分页数据
	 */
	Page<V> queryPage(final Map<String, Object> searchParams, Pageable pageable, Class<V> clazzV, Class<E> clazzE) throws Exception;

	List<V> findAll(Class<V> cls) throws IllegalAccessException, InvocationTargetException, InstantiationException;
	
	void updateApprovalState(BpmStateVO vo, Class<E> cls);

}
