package com.yyjz.icop.pub.base.web;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yycc.common.utils.HttpUtil;
import com.yyjz.icop.exception.BusinessException;
import com.yyjz.icop.pub.base.entity.BaseIdEntity;
import com.yyjz.icop.pub.base.entity.SuperBillMainEntity;
import com.yyjz.icop.pub.base.service.IBaseService;
import com.yyjz.icop.pub.base.vo.SuperBillMainVO;
import com.yyjz.icop.pub.base.vo.SuperVO;
import com.yyjz.icop.pub.business.ISysBizService;
import com.yyjz.icop.pub.myfav.service.IPubMyFavService;
import com.yyjz.icop.pub.myfav.vo.PubMyFavVO;
import com.yyjz.icop.pub.utils.AppContext;
import com.yyjz.icop.pub.utils.DateUtils;
import com.yyjz.icop.pub.utils.HttpRequestUtils;
import com.yyjz.icop.pub.utils.JsonBackData;
import com.yyjz.icop.report.ExcelMetadata;
import com.yyjz.icop.usercenter.service.IUserService;
import com.yyjz.icop.usercenter.vo.UserBaseVO;

/**
 * 所有Controller基类
 */
public abstract class BaseController<E extends BaseIdEntity, V extends SuperVO> {
	/**
	 * 当前登录用户信息的注入接口 获取当前登录用户信息：requestContext.getContext()
	 */
	// @Autowired
	// private RequestContext requestContext;

	private final Logger logger = LoggerFactory.getLogger(BaseController.class);

	@Value("${BPM.BaseUrl}")
	private String BPM_BASEURL;

	@Autowired
	ISysBizService approvalService;

	@Autowired
	IUserService userService;

	/**
	 * 我的收藏及最近查看服务
	 */
	@Autowired
	protected IPubMyFavService iPubMyFavService;

	/**
	 * 由子类实现
	 */
	protected abstract IBaseService<E, V> getService();

	/**
	 * 获取当前登录用户的ID
	 * 
	 * @return
	 */
	public String getCurrUserId() {
		return AppContext.getUserId();
	}

	/**
	 * 获取当前登录用户的名称
	 * 
	 * @return
	 */
	// public String getCurrUserName() {
	// UserVO userCVO = getUserCVO();
	// if (userCVO == null)
	// return null;
	// StaffVO staffVO = userCVO.getStaffVO();
	// if (staffVO == null)
	// return null;
	// return staffVO.getName();
	// }

	/**
	 * 获取当前登录用户组织ID
	 * 
	 * @return
	 */
	// public String getCurrUserOrgId() {
	// UserVO userCVO = getUserCVO();
	// if (userCVO == null)
	// return null;
	// StaffVO staffVO = userCVO.getStaffVO();
	// if (staffVO == null)
	// return null;
	// return staffVO.getDeptId();
	// }

	/**
	 * 获取当前登录用户组织名称
	 * 
	 * @return
	 */
	// public String getCurrUserOrgName() {
	// UserVO userCVO = getUserCVO();
	// if (userCVO == null)
	// return null;
	// StaffVO staffVO = userCVO.getStaffVO();
	// if (staffVO == null)
	// return null;
	// return staffVO.getCompanyId();
	// }

	// private UserVO getUserCVO() {
	// String json = "";//requestContext.getContext();
	// System.out.println("------------json-------------" + json);
	// String userInfo = JSON.parseObject(json).getString("userInfo");
	// System.out.println("------------userInfo-------------" + userInfo);
	// UserVO userVO = JSON.parseObject(userInfo, UserVO.class);
	// return userVO;
	// }

	/**
	 * 从findById接口进入的保存最近查看
	 * 
	 * @param dealRecent
	 *            0-处理，1-不处理
	 * @param billTypeId
	 * @return
	 */
	protected JsonBackData saveMyFavBase(String dealRecent, V vo, String billTypeId) {
		if (dealRecent != null && dealRecent.equals("1")) {
			List<PubMyFavVO> list = new ArrayList<PubMyFavVO>();
			PubMyFavVO favVO = new PubMyFavVO();
			favVO.setBillId(vo.getId());
			favVO.setFavType(1);
			favVO.setBillTypeId(billTypeId);
			list.add(favVO);
			saveMyFavBase(list, billTypeId);
		}
		return null;
	}

	/**
	 * 保存我的收藏
	 * 
	 * @param vos
	 * @return JsonBackData
	 */
	protected JsonBackData saveMyFavBase(List<PubMyFavVO> vos, String billTypeId) {
		JsonBackData back = new JsonBackData();
		for (int i = 0; i < vos.size(); i++) {
			vos.get(i).setBillTypeId(billTypeId);
			vos.get(i).setUserId(getCurrUserId());
		}
		try {
			iPubMyFavService.batchSaveFav(vos);
			back.setSuccess(true);
			back.setBackMsg("我的收藏保存成功！");
		} catch (BusinessException e) {
			back.setSuccess(false);
			back.setBackMsg("我的收藏保存失败，" + e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
			back.setSuccess(false);
			back.setBackMsg("我的收藏保存失败！");
		}
		return back;
	}

	/**
	 * 删除我的收藏
	 * 
	 * @param vos
	 * @return JsonBackData
	 */
	protected JsonBackData deleteMyFavBase(List<PubMyFavVO> vos, String billTypeId) {
		JsonBackData back = new JsonBackData();
		for (int i = 0; i < vos.size(); i++) {
			vos.get(i).setBillTypeId(billTypeId);
			vos.get(i).setUserId(getCurrUserId());
		}
		try {
			iPubMyFavService.batchDeleteFav(vos);
			back.setSuccess(true);
			back.setBackMsg("我的收藏删除成功！");
		} catch (BusinessException e) {
			back.setSuccess(false);
			back.setBackMsg("我的收藏删除失败，" + e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
			back.setSuccess(false);
			back.setBackMsg("我的收藏删除失败！");
		}
		return back;
	}

	protected JsonBackData doSubmit(String sjson, Class<E> clazzE, Class<V> clazzV, HttpServletRequest request) {
		JsonBackData back = new JsonBackData();
		try {
			String url = BPM_BASEURL + "bpm/doSubmit";
			// rjson = HttpUtil.postJson(url, rjson);
			JSONObject jsonData = JSON.parseObject(sjson);
			long time = System.currentTimeMillis();
			JSONObject rjson = HttpRequestUtils.httpPost(url, jsonData, request);
			logger.debug("本次提交审批共用时：" + (System.currentTimeMillis() - time) + "ms");
			boolean success = false;
			if (rjson.getBoolean("success") == null) {
				success = false;
			} else {
				success = rjson.getBoolean("success");
			}
			// boolean success = JSON.parseObject(rjson).get("success") == null
			// ? false
			// :
			// JSON.parseObject(rjson).get("success").toString().equals("true");
			// String msg = JSON.parseObject(rjson).get("msg") == null ? null
			// : JSON.parseObject(rjson).get("msg").toString();
			String msg = rjson.get("msg") == null ? null : rjson.get("msg").toString();
			if (StringUtils.isBlank(msg)) {
				msg = "审批流服务返回信息为空!";
			}
			back.setSuccess(success);
			back.setBackMsg(msg);
			V vo = null;
			if (!success) {
				if ( rjson.getBoolean("noBind").booleanValue()) {

					if (jsonData.containsKey("isSave") && jsonData.getBooleanValue("isSave")) {
						// 是否要保存（考虑提交后还是要更新单据信息，故提交bpm返回后一并保存）
						vo = JSONObject.toJavaObject(jsonData.getJSONObject("bill"), clazzV);
						String userId = jsonData.getString("userId");
						UserBaseVO user = approvalService.getUser(userId);
						((SuperBillMainVO) vo).setBillState(3);
						((SuperBillMainVO) vo).setReviewer(user.getUserName());
						((SuperBillMainVO) vo).setReviewerid(userId);
						((SuperBillMainVO) vo).setReviewtime(new Date());
						vo = updateAfterSubmit(vo, clazzE, clazzV, false);
						return JsonBackData.getInstance(true, "未绑定审批流程，提交即审批通过", vo);

					} else {
						// 调用统一更新审批状态服务
						String billtypeId = jsonData.getString("billtypeId");
						String userId = jsonData.getString("userId");
						String state = "3";
						String billId = jsonData.getJSONObject("bill").getString("id");
						approvalService.updateBillState(billtypeId, billId, state, null, userId);
						/*
						 * //TODO 改状态3 JSONObject data = (JSONObject)
						 * rjson.get("data"); JSONObject billData = (JSONObject)
						 * data.get("bill"); String id = billData.get("id") ==
						 * null ? null : billData.get("id").toString(); E entity
						 * = getService().findEntityById(id, clazzE);
						 * ((SuperBillMainEntity)
						 * entity).setReviewer(AppContext.getUserName());
						 * ((SuperBillMainEntity)
						 * entity).setReviewerid(AppContext.getUserId());
						 * ((SuperBillMainEntity) entity).setReviewtime(new
						 * Date()); ((SuperBillMainEntity)
						 * entity).setBillState(3);
						 */
						vo = getService().findVOById(billId, clazzV);
					}
					// 返回前端
					return JsonBackData.getInstance(true, "未绑定审批流程，提交即审批通过", vo);
				}
				return back;
			}
			JSONObject data = (JSONObject) rjson.get("data");
			String bpmId = data.get("bpmId") == null ? null : data.get("bpmId").toString();
			JSONObject billData = (JSONObject) data.get("bill");
			if (jsonData.containsKey("isSave") && jsonData.getBooleanValue("isSave")) {
				// 是否要保存（考虑提交后还是要更新单据信息，故提交bpm返回后一并保存）
				vo = JSONObject.toJavaObject(jsonData.getJSONObject("bill"), clazzV);
				((SuperBillMainVO) vo).setBpmid(bpmId);
				((SuperBillMainVO) vo).setBillState(1);
				vo = updateAfterSubmit(vo, clazzE, clazzV, true);

			} else {
				String id = billData.get("id") == null ? null : billData.get("id").toString();
				// 更新单据状态
				E entity = getService().findEntityById(id, clazzE);
				((SuperBillMainEntity) entity).setBpmid(bpmId);
				((SuperBillMainEntity) entity).setBillState(1);
				// ((SuperBillMainEntity) entity).setReviewtime(new
				// Timestamp(System.currentTimeMillis()));
				vo = getService().saveEntityReturnVO(entity, clazzE, clazzV);
			}
			back.setBackData(vo);
			back.setSuccess(true);
			back.setBackMsg("提交成功！");
		} catch (BusinessException e) {
			logger.error("", e);
			back.setSuccess(false);
			back.setBackMsg("提交失败, " + e.getMessage());
		} catch (Exception e) {
			logger.error("", e); 
			e.printStackTrace();
			back.setSuccess(false);
			back.setBackMsg("提交失败！"+BPM_BASEURL + "bpm/doSubmit-----"+"sjson:"+sjson);
		}
		return back;
	}

	protected JsonBackData doCallBack(String sjson, Class<E> clazzE, Class<V> clazzV, HttpServletRequest request) {
		JsonBackData back = new JsonBackData();
		try {
			String url = BPM_BASEURL + "bpm/doCallBack";
			// rjson = HttpUtil.postJson(url, rjson);
			JSONObject jsonData = JSON.parseObject(sjson);
			JSONObject rjson = HttpRequestUtils.httpPost(url, jsonData, request);
			boolean success = rjson.get("success") == null ? false : rjson.get("success").toString().equals("true");
			// boolean success = JSON.parseObject(rjson).get("success") == null
			// ? false
			// :
			// JSON.parseObject(rjson).get("success").toString().equals("true");
			// String msg = JSON.parseObject(rjson).get("msg") == null ? null
			// : JSON.parseObject(rjson).get("msg").toString();
			String msg = rjson.get("msg") == null ? null : rjson.get("msg").toString();
			back.setSuccess(success);
			back.setBackMsg(msg);
			if (!success)
				return back;
			JSONObject data = (JSONObject) rjson.get("data");
			JSONObject billData = (JSONObject) data.get("bill");
			String id = billData.get("id") == null ? null : billData.get("id").toString();

			// 更新单据状态
			E entity = getService().findEntityById(id, clazzE);
			((SuperBillMainEntity) entity).setBpmid(null);
			((SuperBillMainEntity) entity).setBillState(0);
			((SuperBillMainEntity) entity).setReviewtime(null);
			V vo = getService().saveEntityReturnVO(entity, clazzE, clazzV);
			back.setBackData(vo);
			back.setSuccess(true);
			back.setBackMsg("收回成功！");
		} catch (BusinessException e) {
			back.setSuccess(false);
			back.setBackMsg("收回失败, " + e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
			back.setSuccess(false);
			back.setBackMsg("收回失败！");
		}
		return back;
	}

	protected JsonBackData doApprove(String rjson, Class<E> clazzE, Class<V> clazzV) {
		JsonBackData back = new JsonBackData();
		try {
			String url = BPM_BASEURL + "bpm/doApprove";
			rjson = HttpUtil.postJson(url, rjson);

			boolean success = JSON.parseObject(rjson).get("success") == null ? false
					: JSON.parseObject(rjson).get("success").toString().equals("true");
			String msg = JSON.parseObject(rjson).get("msg") == null ? null
					: JSON.parseObject(rjson).get("msg").toString();
			back.setSuccess(success);
			back.setBackMsg(msg);
			if (!success)
				return back;

			JSONObject data = (JSONObject) JSON.parseObject(rjson).get("data");
			boolean isEndActivity = data.get("isEndActivity") == null ? false
					: data.get("isEndActivity").toString().equals("true");
			boolean agree = data.get("agree") == null ? true : data.get("agree").toString().equals("true");
			JSONObject billData = (JSONObject) data.get("bill");
			String id = billData.get("id") == null ? null : billData.get("id").toString();

			// 更新单据状态
			E entity = getService().findEntityById(id, clazzE);
			if (agree) {
				((SuperBillMainEntity) entity).setBillState(isEndActivity ? 3 : 2);
			} else {
				((SuperBillMainEntity) entity).setBillState(4);
			}
			((SuperBillMainEntity) entity).setReviewtime(new Timestamp(System.currentTimeMillis()));
			V vo = getService().saveEntityReturnVO(entity, clazzE, clazzV);
			back.setBackData(vo);
			back.setSuccess(true);
			// jsonSub.put("isEndActivity", isEndActivity);
			// jsonSub.put("agree", agree);
			// jsonSub.put("bill", vo);
			// json.put("data", jsonSub);
			back.setBackMsg("审批成功！");
		} catch (BusinessException e) {
			back.setSuccess(false);
			back.setBackMsg("审批失败，" + e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
			back.setSuccess(false);
			back.setBackMsg("审批失败！");
		}
		return back;
	}

	protected JsonBackData doUnApprove(String sjson, Class<E> clazzE, Class<V> clazzV, HttpServletRequest req) {
		JsonBackData back = new JsonBackData();
		try {
			String url = BPM_BASEURL + "bpm/unapprove";
			// rjson = HttpUtil.postJson(url, rjson);
			JSONObject jsonData = JSON.parseObject(sjson);
			JSONObject rjson = HttpRequestUtils.httpPost(url, jsonData, req);
			// if(rjson != null)
			// return JsonBackData.successRtnObject(rjson);
			boolean success = rjson.get("success") == null ? false : rjson.get("success").toString().equals("true");
			// boolean success = JSON.parseObject(rjson).get("success") == null
			// ? false
			// :
			// JSON.parseObject(rjson).get("success").toString().equals("true");
			// String msg = JSON.parseObject(rjson).get("msg") == null ? null
			// : JSON.parseObject(rjson).get("msg").toString();
			String msg = rjson.get("msg") == null ? null : rjson.get("msg").toString();
			back.setSuccess(success);
			back.setBackMsg(msg);
			if (!success)
				return back;
			boolean isStartActivity = rjson.get("isStartActivity") == null ? false
					: rjson.get("isStartActivity").toString().equals("true");
			// boolean agree = data.get("agree") == null ? true :
			// data.get("agree").toString().equals("true");
			// JSONObject billData = (JSONObject) data.get("bill");
			// String id = billData.get("id") == null ? null :
			// billData.get("id").toString();

			// 更新单据状态
			String id = jsonData.get("billId") == null ? null : jsonData.get("billId").toString();
			E entity = getService().findEntityById(id, clazzE);
			if (isStartActivity) {
				((SuperBillMainEntity) entity).setBillState(1);
			} else {
				((SuperBillMainEntity) entity).setBillState(2);
			}
			((SuperBillMainEntity) entity).setReviewtime(new Timestamp(System.currentTimeMillis()));
			V vo = getService().saveEntityReturnVO(entity, clazzE, clazzV);
			back.setBackData(vo);
			back.setSuccess(true);
			// jsonSub.put("isEndActivity", isEndActivity);
			// jsonSub.put("agree", agree);
			// jsonSub.put("bill", vo);
			// json.put("data", jsonSub);
			back.setBackMsg("弃审成功！");
		} catch (BusinessException e) {
			back.setSuccess(false);
			back.setBackMsg("弃审失败，" + e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
			back.setSuccess(false);
			back.setBackMsg("弃审失败！");
		}
		return back;
	}

	public ExcelMetadata getExportExcelTitleColumns() {
		return null;
	}

	/**
	 * 用于导表界面导出时，业务字段转换为名称
	 * @param list
	 * @param properties
	 * @return
	 */
	public List<SuperBillMainVO> transExportExcelColumns(List<SuperBillMainVO> list,List<String> properties) {
		return null;
	}
	
	/**
	 * 提交bpm后业务单据处理
	 * 
	 * @param v
	 *            单据vo
	 * @param clse
	 *            单据实体类
	 * @param clsv
	 *            单据vo类
	 * @param isBind
	 *            是否绑定审批流
	 * @return
	 * @throws BusinessException
	 * @throws Exception
	 */
	public V updateAfterSubmit(V v, Class<E> clse, Class<V> clsv, boolean isBind) throws BusinessException, Exception {
		V newv = null;
		if (v == null)
			throw new BusinessException("bpm提交后未返回单据信息！");
		newv = getService().save(v, clse, clsv);
		if (!isBind) {
			approvalService.afterApprovalProcessor(((SuperBillMainVO) newv).getBillType(), newv.getId(), "3");
		}
		return newv;
	}

}