package com.yyjz.icop.pub.base.web;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.yyjz.icop.pub.utils.JsonBackData;
import com.yyjz.icop.support.api.service.IBillCodeService;

@Controller
public class GetBCController {

	// @Autowired private IBillcodeGenerator generator;

	@Autowired
	private IBillCodeService generatorService;

	private static final Logger LOGGER = LoggerFactory.getLogger(GetBCController.class);

	/**
	 * 
	 * @Title: getbc
	 * @Description: 获取一个单据编码
	 * @param id
	 *            编码规则主键
	 * @return JSON 返回类型
	 * @throws BillCodeException
	 */
	@RequestMapping("/getbc/{id}")
	@ResponseBody
	public JsonBackData getbc(@PathVariable String id) throws Exception {
		String code = null;
		// code = generator.generateBillcode(Long.valueOf(id));
		// code = generatorService.getCodeById(id);
		code = generatorService.getCodeByRulecode(id);
		JSONObject o = new JSONObject();
		o.put("code", code);
		return JsonBackData.successRtnObject(o);
	}

	/**
	 * 
	 * @Title: getbcpre
	 * @Description: 获取单据预编码
	 * @param id
	 * @return String 返回类型
	 * @throws BillCodeException
	 */
	// @RequestMapping("/getbc/pre/{id}")
	// @ResponseBody
	// public JSON getbcpre(@PathVariable String id) throws BillCodeException,
	// Exception {
	// String code = null;
	// try {
	// code = generator.generatePreBillcode(Long.valueOf(id));
	// } catch (Exception e) {
	// LOGGER.error(e.getMessage());
	// throw new BillCodeException("生成单据预编码失败!");
	// }
	// JSONObject o = new JSONObject();
	// o.put("code", code);
	// return o;
	// }

	/**
	 * 
	 * @Title: commitpre
	 * @Description: 提交单据预编码
	 * @param id
	 * @param code
	 * @return String 返回类型
	 * @throws BillCodeException
	 */
	// @RequestMapping("/getbc/cmpre/{id}/{code}")
	// @ResponseBody
	// public JSON commitpre(@PathVariable String id, @PathVariable String code)
	// throws BillCodeException, Exception {
	// try {
	// generator.commitPreBillcode(Long.valueOf(id), code);
	// } catch (Exception e) {
	// LOGGER.error(e.getMessage());
	// throw e;
	// }
	// JSONObject o = new JSONObject();
	// o.put("suc", 1);
	// return o;
	// }

	/**
	 * 
	 * @Title: rbpre @Description: 回滚单据预编码 @param @param id @param @param
	 * code @param @return @param @throws BillCodeException @param @throws
	 * Exception 设定文件 @return String 返回类型 @throws
	 */
	// @RequestMapping("/getbc/rbpre/{id}/{code}")
	// @ResponseBody
	// public JSON rbpre(@PathVariable String id, @PathVariable String code)
	// throws BillCodeException, Exception {
	// try {
	// generator.rollbackPreBillcode(Long.valueOf(id), code);
	// } catch (Exception e) {
	// LOGGER.error(e.getMessage());
	// throw e;
	// }
	// JSONObject o = new JSONObject();
	// o.put("suc", 1);
	// return o;
	// }

	/**
	 * 
	 * @Title: rtnbc
	 * @Description: 退回单据编码
	 * @param id
	 * @param code
	 * @return String 返回类型
	 * @throws BillCodeException
	 */
	// @RequestMapping("/getbc/rtnbc/{id}/{code}")
	// @ResponseBody
	// public JSON rtnbc(@PathVariable String id, @PathVariable String code)
	// throws BillCodeException, Exception {
	// try {
	// generator.returnBillcode(Long.valueOf(id), code);
	// } catch (Exception e) {
	// LOGGER.error(e.getMessage());
	// throw e;
	// }
	// JSONObject o = new JSONObject();
	// o.put("suc", 1);
	// return o;
	// }

	/**
	 * 
	 * @Title: drtnbc
	 * @Description: 删除退回单据编码
	 * @param id
	 * @param code
	 * @return String 返回类型
	 * @throws BillCodeException
	 */
	// @RequestMapping("/getbc/drtnbc/{id}/{code}")
	// @ResponseBody
	// public JSON drtnbc(@PathVariable String id, @PathVariable String code)
	// throws BillCodeException, Exception {
	// try {
	// generator.destroyBillcode(Long.valueOf(id), code);
	// } catch (Exception e) {
	// LOGGER.error(e.getMessage());
	// throw e;
	// }
	// JSONObject o = new JSONObject();
	// o.put("suc", 1);
	// return o;
	// }
	//
}
