package com.yyjz.icop.pub.base.web;

import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.yyjz.icop.exception.BusinessException;
import com.yyjz.icop.orgcenter.orgcenter.service.IOrgCenterService;
import com.yyjz.icop.orgcenter.orgcenter.vo.OrgCenterVO;
import com.yyjz.icop.pub.utils.JsonBackData;

@RestController
@RequestMapping(value = "orginfo")
public class GetOrgController {

	private Logger logger = LoggerFactory.getLogger(GetProjectController.class);

	@Autowired
	private IOrgCenterService orgservice;

	@RequestMapping(path = "/findbycompanyid", method = RequestMethod.GET)
	public JsonBackData getProject(@RequestParam(name = "companyId") String companyId) {
		return findOrgInfo(companyId);
	}

	@RequestMapping(path = "/findbycompanyid", method = RequestMethod.POST)
	public JsonBackData getPostProject(@RequestBody(required = true) String companyId) {
		return findOrgInfo(companyId);
	}

	private JsonBackData findOrgInfo(String companyId) {
		OrgCenterVO pro = null;
		try {
			pro = orgservice.getOrgByCodeAndCompany("0004", companyId);
		} catch (Exception e) {
			logger.error("查询部门失败", e.getCause());
			throw new BusinessException("调用查询组织服务失败，请稍后重试");
		}
		if (pro != null) {
			Map<String, Object> res = new HashMap<>();
			res.put("orgid", pro.getId());
			res.put("orgcode", pro.getOrgCode());
			res.put("orgname", pro.getOrgName());

			res.put("porgid", pro.getPid());
			res.put("porgname", pro.getPname());
			res.put("orgLevel", pro.getLevelType());
			return JsonBackData.successRtnObject(res);
		}
		return JsonBackData.fail("此组织无关联职能组织");

	}

	private JsonBackData findOrgInfo(String zncode, String companyId) {
		try {
			OrgCenterVO pro = orgservice.getOrgByCodeAndCompany(zncode, companyId);
			if (pro != null) {
				Map<String, Object> res = new HashMap<>();
				res.put("orgid", pro.getOrgFunId());
				res.put("orgcode", pro.getOrgCode());
				res.put("orgname", pro.getOrgName());

				res.put("porgid", pro.getPid());
				res.put("porgname", pro.getPname());
				res.put("orgLevel", pro.getLevelType());
				return JsonBackData.successRtnObject(res);
			}
			return JsonBackData.fail("此组织无关联职能组织");
		} catch (Exception e) {
			logger.error("查询职能部门失败", e.getCause());
			return JsonBackData.fail(e.getMessage());
		}
	}
}
