package com.yyjz.icop.pub.base.web;

import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.yyjz.icop.exception.BusinessException;
import com.yyjz.icop.pub.utils.JsonBackData;
import com.yyjz.icop.share.api.bo.ProjectBO;
import com.yyjz.icop.share.api.service.ProjectAPIService;

@RestController
@RequestMapping(value = "project")
public class GetProjectController {

	private Logger logger = LoggerFactory.getLogger(GetProjectController.class);

	@Autowired
	ProjectAPIService projectService;

	@RequestMapping(path = "/findbyorgid", method = RequestMethod.GET)
	public JsonBackData getProject(@RequestParam(name = "orgid") String orgid) {
		return find(orgid);
	}

	@RequestMapping(path = "/findbyorgid", method = RequestMethod.POST)
	public JsonBackData getPostProject(@RequestBody(required = true) String orgid) {
		return find(orgid);
	}

	private JsonBackData find(String orgid) {
		ProjectBO pro = null;
		try {
			pro = projectService.queryProjectByOrgId(orgid);
		} catch (Exception e) {
			logger.error("查询项目失败", e.getCause());
			throw new BusinessException(e.getMessage());
		}
		if ((pro != null) && (pro.getProjectId() != null) && (pro.getProjectName() != null)) {
			Map<String, String> res = new HashMap<>();
			res.put("projectName", pro.getProjectName());
			res.put("projectCode", pro.getProjectCode());
			res.put("projectId", pro.getProjectId());
			res.put("Address", pro.getAddress());
			return JsonBackData.successRtnObject(res);
		}
		return JsonBackData.fail("此组织无关联项目");
	}
}
