package com.yyjz.icop.pub.business;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

/**
 *
 * @ClassName: BusinessBeanFactoryPostProcessor 
 * @Description: spring启动后，注册单据类型，启用审批/打印等相关业务
 * @author liYang liyangs@yonyou.com 
 * @date 2016年12月6日 下午5:08:38 
 *  
 */
@Component
public class BusinessBeanFactoryPostProcessor
		implements ApplicationContextAware, BeanFactoryPostProcessor, ApplicationListener<ContextRefreshedEvent> {

	private final Logger logger = LoggerFactory.getLogger(BusinessBeanFactoryPostProcessor.class);

	private ApplicationContext context;

	private BeanFactory beanFactory;

	@Override
	public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
		this.beanFactory = beanFactory;
	}

	@Override
	public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
		this.context = applicationContext;
	}

	@Override
	public void onApplicationEvent(ContextRefreshedEvent event) {
		if (event.getApplicationContext().getParent() == null) {
			logger.info("Starting register billType Processors：");
			ISysBizService sysBizService = context.getBean(ISysBizService.class);
			int i = 0;
			String[] beanNames = ((ConfigurableListableBeanFactory) beanFactory)
					.getBeanNamesForType(IBusinessService.class);
			for (String beanName : beanNames) {
				i++;
				sysBizService.registProcessor((IBusinessService) context.getBean(beanName));
			}
			logger.info("register billType pocessors ending, count billType: " + i);
		}
	}

}
