package com.yyjz.icop.pub.business;

import com.yyjz.icop.pub.base.entity.SuperBillMainEntity;
import com.yyjz.icop.pub.base.vo.SuperBillMainVO;
import com.yyjz.icop.pub.utils.JsonBackData;

/**
 *
 * @ClassName: IBusinessService 
 * @Description: 封装实际审批流、打印等相关业务
 * @author liYang liyangs@yonyou.com 
 * @date 2016年12月5日 下午3:40:11 
 *  
 */
public interface IBusinessService {
	
	/**
	 *
	 * @Title: getBillType 
	 * @Description: 获取单据类型
	 * @param 
	 * @return 
	 * @throws 
	 */
	public String getBillType();
	
	/**
	 *
	 * @Title: getMainEntityClass 
	 * @Description: 获取主实体类型
	 * @param 
	 * @return 
	 * @throws 
	 */
	public <T extends SuperBillMainEntity> Class<T> getMainEntityClass();
	
	/**
	 *
	 * @Title: getMainVOClass 
	 * @Description: 获取关联VO类型
	 * @param 
	 * @return 
	 * @throws 
	 */
	public <T extends SuperBillMainVO> Class<T> getMainVOClass();

	/**
	 *
	 * @Title: afterApprovalProcessor 
	 * @Description: 审批流后处理方法
	 * @param 
	 * @return 
	 * @throws 
	 */
	public JsonBackData afterApprovalProcessor(String billId, Integer state);
}
