package com.yyjz.icop.pub.business;

import com.yyjz.icop.pub.utils.JsonBackData;
import com.yyjz.icop.usercenter.vo.UserBaseVO;

/**
 * 系统业务相关接口
 *
 * @ClassName: ISysBizService 
 * @Description: 
 * @author liYang liyangs@yonyou.com 
 * @date 2016年12月5日 下午3:12:46 
 *  
 */
public interface ISysBizService {
	
	/**
	 *
	 * @Title: checkSupport 
	 * @Description: 校验是否支持此单据类型
	 * @param 
	 * @return 
	 * @throws 
	 */
	public boolean checkSupport(String billType);
	
	/**
	 *
	 * @param userId 
	 * @param bpmId 
	 * @Title: updateBillState 
	 * @Description: 更新单据状态
	 * @param 
	 * @return 
	 * @throws 
	 */
	public JsonBackData updateBillState(String billType, String billId, String state, String bpmId, String userId);
	
	/**
	 *
	 * @Title: afterApprovalProcessor 
	 * @Description: 单据审批后处理流程
	 * @param 
	 * @return 
	 * @throws 
	 */
	public JsonBackData afterApprovalProcessor(String billType, String billId, String states);
	
	/**
	 *
	 * @Title: registProcessor 
	 * @Description: 注册处理器
	 * @param 
	 * @return 
	 * @throws 
	 */
	public void registProcessor(IBusinessService service);
	
	/**
	 * @Title: getUser 
	 * @Description: 获取用户信息
	 * @param userId
	 * @return
	 */
	public UserBaseVO getUser(String userId);
	
}
