package com.yyjz.icop.pub.business;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import javax.persistence.Table;
import javax.transaction.Transactional;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.yyjz.icop.exception.BusinessException;
import com.yyjz.icop.pub.base.dao.BaseQueryDao;
import com.yyjz.icop.pub.utils.AppContext;
import com.yyjz.icop.pub.utils.DateUtils;
import com.yyjz.icop.pub.utils.JsonBackData;
import com.yyjz.icop.usercenter.service.IUserService;
import com.yyjz.icop.usercenter.vo.UserBaseVO;

/**
 * 
 *
 * @ClassName: SysBizServiceImpl 
 * @Description:
 * @author liYang liyangs@yonyou.com 
 * @date 2016年12月5日 下午4:18:53    
 */
@Service("sysBizService")
public class SysBizServiceImpl implements ISysBizService {

	private final Logger logger = LoggerFactory.getLogger(SysBizServiceImpl.class);

	private Boolean excAfter = true;

	@Autowired
	private BaseQueryDao baseDAO;
	
	@Autowired
	IUserService userService;

	private Map<String, IBusinessService> services = Collections
			.synchronizedMap(new HashMap<String, IBusinessService>());

	@Override
	public boolean checkSupport(String billType) {
		if (null == billType)
			throw new NullPointerException("The BillType from BPM system is null, cann't do next work ");
		for (String bt : services.keySet()) {
			if (billType.trim().equalsIgnoreCase(bt)) {
				return true;
			}
		}
		logger.info("Can't find the BillType "+ billType+ " , please check args and imps of IbusinessService");
		return false;
	}

	@Override
	@Transactional
	public JsonBackData updateBillState(String billType, String billId, String state, String bpmId, String userId) {
		IBusinessService service = null;
		if (checkSupport(billType)) {
			service = services.get(billType);
		} else {
			throw new RuntimeException(
					"Maybe BillType : " + billType + " is not defined, please check args and imps of IbusinessService");
		}
		if(billId == null)
			throw new RuntimeException("BillId not be null, please check the args ");
		if(state == null)
			throw new RuntimeException("State not be null, please check the args ");
		Table table = service.getMainEntityClass().getAnnotation(Table.class);
		String tableName = table.name();
		if (!StringUtils.isNotBlank(tableName))
			throw new RuntimeException("The class: " + service.getMainEntityClass().getName()
					+ " has not @Table annotation, cant't bind the billType: " + billType);
		String updSql = null;
		String crtTime = DateUtils.toStdCrtDateString();
		String uUserId = null;
		String uUserName = null;
		try {
			uUserId = AppContext.getUserId();
			uUserName = AppContext.getUserName();
			if(StringUtils.isBlank(uUserId) || StringUtils.isBlank(uUserName))
				throw new RuntimeException();
		} catch (Exception e) {
			logger.error("Application context is unavailable, reviewer cann't be setted, will set reviewer from the result query by userId from BPM");
			if(StringUtils.isBlank(userId)){
				throw new RuntimeException("Application context is unavailable, userId from BPM is null, reviewer cann't be setted");
			}
			UserBaseVO user = null;
			try {
				user = userService.findUserById(userId);
			} catch (Exception e1) {
				throw new RuntimeException("Application context is unavailable, The dubbo service: IUserService is not available, reviewer cann't be setted");
			}
			if(user == null )
				throw new RuntimeException("Application context is unavailable, The user query by id from BPM is empty, reviewer cann't be setted");
			uUserId = user.getUserId();
			uUserName = user.getUserName();
		}
		try {
			updSql = new StringBuffer("update ").append(tableName).
					append(" set bill_state = ").append(state)
					.append(", reviewerid='").append(uUserId).append("'").
					append(", reviewer='").append(uUserName).append("'").
					append(", reviewtime='").append(crtTime).append("' where id= '").append(billId).append("'").toString();
			baseDAO.executeUpdateSQL(updSql);
		} catch (Exception e) {
			logger.error("Excute SQL fail: " + updSql);
			throw new RuntimeException("Update billState fail, excute SQL: " + updSql, e.getCause());
		}
		if (excAfter) {
			try {
				JsonBackData res = service.afterApprovalProcessor(billId, Integer.parseInt(state));
				if(res != null && !res.isSuccess())
					throw new BusinessException(res.getBackMsg());
			} catch (Exception e) {
				throw new BusinessException(e.getMessage());
			}
		}
		return JsonBackData.success();
	}

	@Override
	@Transactional
	public JsonBackData afterApprovalProcessor(String billType, String billId, String state) {
		IBusinessService service = null;
		if (checkSupport(billType)) {
			service = services.get(billType);
		} else {
			throw new RuntimeException(
					"Maybe BillType : " + billType + " is not defined, please check args and imps of IbusinessService");
		}
		return service.afterApprovalProcessor(billId, Integer.parseInt(state));
	}

	public void setExcAfter(Boolean excAfter) {
		this.excAfter = excAfter;
	}

	@Override
	public void registProcessor(IBusinessService service) {
		logger.info("BillType: "+ service.getBillType()+ " ,Processor: "+ service.getClass()+ "#", service+ " is registed.");
		services.put(service.getBillType(), service);
	}
	
	
	public UserBaseVO getUser(String userId){
		UserBaseVO user = new UserBaseVO();
		String uUserId = null;
		String uUserName = null;
		try {
			uUserId = AppContext.getUserId();
			uUserName = AppContext.getUserName();
			if(StringUtils.isBlank(uUserId) || StringUtils.isBlank(uUserName))
				throw new RuntimeException();
			user.setUserId(uUserId);
			user.setUserName(uUserName);
		} catch (Exception e) {
			logger.error("Application context is unavailable, reviewer cann't be setted, will set reviewer from the result query by userId from BPM");
			if(StringUtils.isBlank(userId)){
				throw new RuntimeException("Application context is unavailable, userId from BPM is null, reviewer cann't be setted");
			}
			try {
				user = userService.findUserById(userId);
			} catch (Exception e1) {
				throw new RuntimeException("Application context is unavailable, The dubbo service: IUserService is not available, reviewer cann't be setted");
			}
			if(user == null )
				throw new RuntimeException("Application context is unavailable, The user query by id from BPM is empty, reviewer cann't be setted");
		}
		return user;

	}

}
