package com.yyjz.icop.pub.message;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

import com.alibaba.fastjson.JSONObject;
import com.yyjz.icop.exception.BusinessException;

public class DefaultMessageSender implements MessageCenter {
	
	private final Logger logger = LoggerFactory.getLogger(DefaultMessageSender.class);

	private final String NOTICE = "notice";// 通知
	private final String WARNING = "earlywarning";// 预警
	private final String TASK = "task";// 任务

	@Value("${message.url.key}")
	public String MESSAGE_URL_KEY;

	@Value("${message.domain}")
	private String MESSAGE_DOMAIN;
	
	@Value("${message.domain}")
	private String MESSAGE_MOBILE_DOMAIN;

	public DefaultMessageSender() {
	}

	@Override
	public Integer notice(String senderId, MessageChannel[] channels, String[] recevierIds, String subject,
			String content) {
		return push(senderId, channels, recevierIds, NOTICE, subject, content);
	}

	@Override
	public Integer warning(String senderId, MessageChannel[] channels, String[] recevierIds, String subject,
			String content) {
		return push(senderId, channels, recevierIds, WARNING, subject, content);
	}

	@Override
	public Integer task(String senderId, MessageChannel[] channels, String[] recevierIds, String subject,
			String content) {
		return push(senderId, channels, recevierIds, TASK, subject, content);
	}

	@Override
	public Integer sysNotice(String senderId, String[] recevierIds, String subject, String content) {
		return push(senderId, new MessageChannel[] { MessageChannel.Sys }, recevierIds, NOTICE, subject, content);
	}

	@Override
	public Integer sysWarning(String senderId, String[] recevierIds, String subject, String content) {
		return push(senderId, new MessageChannel[] { MessageChannel.Sys }, recevierIds, WARNING, subject, content);
	}

	@Override
	public Integer sysTask(String senderId, String[] recevierIds, String subject, String content) {
		return push(senderId, new MessageChannel[] { MessageChannel.Sys }, recevierIds, TASK, subject, content);
	}

	private Integer push(String senderId, MessageChannel[] channels, String[] recevierIds, String msgType,
			String subject, String content) {
		if (StringUtils.isBlank(senderId) )
			throw new BusinessException("消息发送人不能为空！");
		if(StringUtils.isBlank(msgType)) 
			throw new BusinessException("消息类型不能为空！");
		if(StringUtils.isBlank(subject))
			throw new BusinessException("消息标题不能为空！");
		if(channels == null || channels.length == 0)
			throw new BusinessException("消息频道不能为空！");
		if(recevierIds == null || recevierIds.length == 0)
			throw new BusinessException("消息接收人不能为空！");
		Map<String, Object> message = new HashMap<>();
		String[] mcs = new String[channels.length];
		int i = 0;
		for (MessageChannel c : channels) {
			mcs[i++] = c.getCode();
		}
		message.put("sendman", senderId);
		message.put("channel", channels);
		message.put("recevier", recevierIds);
		message.put("msgtype", msgType);
		message.put("subject", subject);
		message.put("content", content);
		Map<String, String> requestData = new HashMap<>();
		requestData.put("data", JSONObject.toJSONString(message));
		String result = post(requestData);
		JSONObject jsonRes = JSONObject.parseObject(result);
		if (jsonRes == null || jsonRes.get("status") == null) {
			throw new BusinessException("消息服务调用成功，返回信息为空！");
		}
		return jsonRes.getInteger("status");
	}

	private String post(Map<String, String> params) {
		List<NameValuePair> urlparams = new ArrayList<NameValuePair>();
		if (params != null && !params.isEmpty()) {
			for (Map.Entry<String, String> entry : params.entrySet()) {
				String value = entry.getValue();
				if (value != null) {
					urlparams.add(new BasicNameValuePair(entry.getKey(), (String) value));
				}
			}
		}
		UrlEncodedFormEntity uefEntity;
		CloseableHttpClient httpclient = HttpClients.createDefault();
		try {
			uefEntity = new UrlEncodedFormEntity(urlparams, "UTF-8");
			HttpPost httppost = new HttpPost(getSysUrl());
			httppost.setEntity(uefEntity);
			CloseableHttpResponse response = httpclient.execute(httppost);
			StatusLine s = response.getStatusLine();
			if(s.getStatusCode() == 200)
				return EntityUtils.toString(response.getEntity());
			else if (s.getStatusCode() == 404 ) {
				throw new BusinessException("不能连接到目标服务器："+ getSysUrl());
			}else {
				throw new BusinessException("目标服务器返回异常状态："+ getSysUrl());
			}
		} catch (BusinessException e) {
			logger.error(e.getMessage(), e.getCause());
			throw new BusinessException(e);
		} catch (Exception e) {
			logger.error(e.getMessage(), e.getCause());
			throw new BusinessException("发送消息到目标服务器失败");
		} finally {
			// 关闭连接,释放资源
			try {
				httpclient.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

	public String getSysUrl() {
		return MESSAGE_URL_KEY;
	}

	@Override
	public String getDomain() {
		try {
			return URLEncoder.encode(MESSAGE_DOMAIN, "utf-8");
		} catch (UnsupportedEncodingException e) {
			return MESSAGE_DOMAIN;
		}
	}
	
	@Override
	public String getMobileDomain() {
			return MESSAGE_MOBILE_DOMAIN;
	}

}
