package com.yyjz.icop.pub.message;

/**
 * 消息服务接口
 *
 * @ClassName: MessageCenter 
 * @Description:
 * @author liYang liyangs@yonyou.com 
 * @date 2016年8月30日 下午6:25:42    
 */
public interface MessageCenter {
	
	/**
	 * 通知消息服务
	 *
	 * @Title: notice 
	 * @Description:
	 * @param senderId
	 *            发送人id
	 * @param channels
	 *            消息渠道
	 * @param recevierIds
	 *            接收人id集合
	 * @param subject
	 *            消息主题
	 * @param content
	 *            消息内容
	 * @return 响应码：1-成功
	 */
	public Integer notice(String senderId, MessageChannel[] channels, String[] recevierIds, String subject,
			String content);
	
	/**
	 * 预警消息服务
	 *
	 * @Title: notice 
	 * @Description:
	 * @param senderId
	 *            发送人id
	 * @param channels
	 *            消息渠道
	 * @param recevierIds
	 *            接收人id集合
	 * @param subject
	 *            消息主题
	 * @param content
	 *            消息内容
	 * @return 响应码：1-成功
	 */
	public Integer warning(String senderId, MessageChannel[] channels, String[] recevierIds, String subject,
			String content);
	
	/**
	 * 任务消息服务
	 *
	 * @Title: notice 
	 * @Description:
	 * @param senderId
	 *            发送人id
	 * @param channels
	 *            消息渠道
	 * @param recevierIds
	 *            接收人id集合
	 * @param subject
	 *            消息主题
	 * @param content
	 *            消息内容
	 * @return 响应码：1-成功
	 */
	public Integer task(String senderId, MessageChannel[] channels, String[] recevierIds, String subject,
			String content);
	
	/**
	 * 系统默认通知消息服务
	 *
	 * @Title: notice 
	 * @Description:
	 * @param senderId
	 *            发送人id
	 * @param recevierIds
	 *            接收人id集合
	 * @param subject
	 *            消息主题
	 * @param content
	 *            消息内容
	 * @return 响应码：1-成功
	 */
	public Integer sysNotice(String senderId, String[] recevierIds, String subject, String content);
	
	/**
	 * 系统默认预警消息服务
	 *
	 * @Title: notice 
	 * @Description:
	 * @param senderId
	 *            发送人id
	 * @param recevierIds
	 *            接收人id集合
	 * @param subject
	 *            消息主题
	 * @param content
	 *            消息内容
	 * @return 响应码：1-成功
	 */
	public Integer sysWarning(String senderId, String[] recevierIds, String subject, String content);
	
	/**
	 * 系统默认任务消息服务
	 *
	 * @Title: notice 
	 * @Description:
	 * @param senderId
	 *            发送人id
	 * @param recevierIds
	 *            接收人id集合
	 * @param subject
	 *            消息主题
	 * @param content
	 *            消息内容
	 * @return 响应码：1-成功
	 */
	public Integer sysTask(String senderId, String[] recevierIds, String subject, String content);
	
	public String getDomain();
	
	public String getMobileDomain();
}
