package com.yyjz.icop.pub.myfav.dao;

import java.util.List;

import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import com.yyjz.icop.pub.base.dao.BaseDao;
import com.yyjz.icop.pub.myfav.entity.PubMyFavEntity;

@Repository
public interface PubMyFavDao extends BaseDao<PubMyFavEntity> {

	@Query("select fav from PubMyFavEntity fav where fav.userId = :userId and billTypeId = :billTypeId and billId = :billId and favType = :favType")
	List<PubMyFavEntity> findByUserIdAndBillTypeIdAndBillIdAndFavType(
			@Param("userId") String userId,
			@Param("billTypeId") String billTypeId,
			@Param("billId") String billId,
			@Param("favType") int favType);

}
