package com.yyjz.icop.pub.myfav.entity;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yyjz.icop.pub.base.entity.BaseIdEntity;

@Entity
@Table(name = "pub_myfav")
@SuppressWarnings("serial")
public class PubMyFavEntity extends BaseIdEntity {

	@Column(name = "user_id")
	private String userId;

	@Column(name = "bill_type_id")
	private String billTypeId;

	@Column(name = "bill_id")
	private String billId;

	@Column(name = "fav_type")
	private int favType;

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@Column(name = "fav_date")
	private Date favDate;

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public String getBillTypeId() {
		return billTypeId;
	}

	public void setBillTypeId(String billTypeId) {
		this.billTypeId = billTypeId;
	}

	public String getBillId() {
		return billId;
	}

	public void setBillId(String billId) {
		this.billId = billId;
	}

	public int getFavType() {
		return favType;
	}

	public void setFavType(int favType) {
		this.favType = favType;
	}

	public Date getFavDate() {
		return favDate;
	}

	public void setFavDate(Date favDate) {
		this.favDate = favDate;
	}

}
