package com.yyjz.icop.pub.myfav.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.yycc.common.exception.BusinessException;
import com.yyjz.icop.pub.base.dao.BaseQueryDao;
import com.yyjz.icop.pub.base.service.impl.BaseServiceImpl;
import com.yyjz.icop.pub.myfav.dao.PubMyFavDao;
import com.yyjz.icop.pub.myfav.entity.PubMyFavEntity;
import com.yyjz.icop.pub.myfav.service.IPubMyFavService;
import com.yyjz.icop.pub.myfav.vo.PubMyFavVO;

@Service
public class PubMyFavServiceImpl extends BaseServiceImpl<PubMyFavEntity, PubMyFavVO> implements IPubMyFavService {

	private static final String RECENT_DAYS = "2";// 删除两天前的数据
	@Autowired
	private PubMyFavDao dao;
	@Autowired
	protected BaseQueryDao queryDao;
//
//	@Override
//	public Page<PubMyFavVO> queryPage(final Map<String, Object> searchParams, PageRequest pageRequest) throws Exception {
//		Page<PubMyFavEntity> page = dao.findAll(new Specification<PubMyFavEntity>() {
//			@Override
//			public Predicate toPredicate(Root<PubMyFavEntity> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
//				Predicate criteria = cb.conjunction();
//				return cb.and(criteria, cb.equal(root.get("dr"), 0));
//			}
//		}, pageRequest);
//		long count = page.getTotalElements();
//		List<PubMyFavVO> listVO = new ArrayList<PubMyFavVO>();
//		for (PubMyFavEntity entity : page.getContent()) {
//			PubMyFavVO vo = new PubMyFavVO();
//			BeanUtils.copyProperties(entity, vo);
//			listVO.add(vo);
//		}
//		Page<PubMyFavVO> results = new PageImpl<PubMyFavVO>(listVO, pageRequest, count);
//		return results;

//		return page;
//		return dao.findAll(new Specification<PubMyFavEntity>() {
//			@Override
//			public Predicate toPredicate(Root<PubMyFavEntity> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
//				Predicate criteria = cb.conjunction();
//				criteria = cb.and(criteria, cb.equal(root.get("dr"), 0));
//				query.where(criteria);
//				return query.getRestriction();
//			}
//		}, pageable);
//	}

	@Transactional
	public void batchSaveFav(List<PubMyFavVO> vos)  throws BusinessException {
		List<PubMyFavEntity> list = new ArrayList<PubMyFavEntity>();
		for (int i = 0; i < vos.size(); i++) {
			if (vos.get(i).getFavType() == 1) {// 最近查看保存时要删除几天前的数据
				try {
					queryDao.executeUpdateSQL("delete from pub_myfav where bill_type_id = '" + vos.get(i).getBillTypeId()
							+ "' and fav_type = 1 and user_id = '" + vos.get(i).getUserId()
							+ "' and fav_date < date_sub(now(), interval " + RECENT_DAYS + " day)");
				} catch (Exception e) {
					throw new BusinessException("执行最近查看删除语句失败！");
				}
			}
			List<PubMyFavEntity> entitys = ((PubMyFavDao) getBaseDao()).findByUserIdAndBillTypeIdAndBillIdAndFavType(
							vos.get(i).getUserId(), vos.get(i).getBillTypeId(), vos.get(i).getBillId(), vos.get(i).getFavType());
			PubMyFavEntity entity = new PubMyFavEntity();
			if (entitys != null && entitys.size() > 0) {
				entity = entitys.get(0);
				entity.setTs(new Timestamp(System.currentTimeMillis()));
			} else {
				BeanUtils.copyProperties(vos.get(i), entity);
			}
			entity.setFavDate(new Timestamp(System.currentTimeMillis()));
			list.add(entity);			
		}
		dao.save(list);
	}

	@Transactional
	public void batchDeleteFav(List<PubMyFavVO> vos)  throws BusinessException {
		List<PubMyFavEntity> list = new ArrayList<PubMyFavEntity>();
		for (int i = 0; i < vos.size(); i++) {
			List<PubMyFavEntity> entitys = ((PubMyFavDao) getBaseDao()).findByUserIdAndBillTypeIdAndBillIdAndFavType(
					vos.get(i).getUserId(), vos.get(i).getBillTypeId(), vos.get(i).getBillId(), vos.get(i).getFavType());
			PubMyFavEntity entity = new PubMyFavEntity();
			if (entitys != null && entitys.size() > 0) {
				entity = entitys.get(0);
			} else {
				throw new BusinessException("删除收藏失败，该单据未被收藏！");
			}
//			BeanUtils.copyProperties(vos.get(i), entity);
			list.add(entity);
		}
		dao.delete(list);
	}

}
