package com.yyjz.icop.pub.portalnode.web;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.yyjz.icop.pub.base.dao.BaseQueryDao;
import com.yyjz.icop.pub.portalnode.vo.PortalNodeVO;


/**
 * 应用小磁贴controller
 * @author LIAO
 *
 */
@RestController
@RequestMapping(value = "portalnode")
public class PortalnodeController {

	@Autowired
	protected BaseQueryDao queryDao;
	
	private Logger logger = LoggerFactory.getLogger(PortalnodeController.class);

	@Value("${url.frontproject:}")
	private String frontprojectSvrUrl; //前端工程服务地址
	
	@Value("${url.backproject:}")
	private String backprojectSvrUrl; //后端工程服务地址
	
	@Value("${url.moblieoffice:}")
	private String moblieofficeSvrUrl;//移动
	
	/**
	 * 动态生成xml
	 * @param nodecode
	 * @param request
	 * @return
	 */
	@ResponseBody
	@RequestMapping(value = "/xml/{nodecode}", method=RequestMethod.GET, produces={"application/xhtml+xml;charset=UTF-8"})
	public String dynamicCreatXML(@PathVariable String nodecode, HttpServletRequest request){
		
		Map<String,Object> nodevalues =  findModelByCode(nodecode);
		if(nodevalues==null){
			//没有配置
			logger.error("节点编码为"+nodecode+"在pub_protal表中没有配置信息");
			return null;
		}
		
		String rootpath =  request.getServletContext().getRealPath("");
		String filepath = rootpath + "/magnet/template/" + nodevalues.get("xmltemplate") +".xml";//获取后端工程中xmltemplate
		
		String listurl = null;
		String cardurl = null;
		
		if( nodevalues.get("backprojectname") == null || nodevalues.get("backprojectname").equals("")){
			logger.error("节点编码为"+nodecode+"在pub_protal表中没有配置后端工程信息");
			return null;
		}
		String styleslocation =backprojectSvrUrl +"/"+ nodevalues.get("backprojectname") + "/magnet";//后端url +后端工程名称 +styles放置位置
		
//		String styleslocation =backprojectSvrUrl +"/icop-materialmgr-web/magnet";//后端url +后端工程名称 +styles放置位置(现在小磁贴文件都在icop-materialmgr-web文件中)
		nodevalues.put("styleslocation", styleslocation);
		
		if((int)nodevalues.get("ismobile") == 0){//0:中建云,1:优办云
			
			//前端url + /#/ + pub_protalnode表中配置的前端工程名称
			if( nodevalues.get("frontprojectname") == null || nodevalues.get("frontprojectname").equals("")){
				logger.error("节点编码为"+nodecode+"在pub_protal表中没有配置前端工程信息");
				return null;
			}
			if( nodevalues.get("listurl") == null || nodevalues.get("listurl").equals("")){
				nodevalues.put("showlist", "none");//不显示“去瞧瞧”
				nodevalues.put("listurl","xxx");
			}else{
				listurl = frontprojectSvrUrl + "/" + nodevalues.get("frontprojectname") + "/#/"+nodevalues.get("listurl");				
				nodevalues.put("showlist", "block");//显示“去瞧瞧”
				nodevalues.put("listurl",listurl);
			}
			if(nodevalues.get("cardurl") == null || nodevalues.get("cardurl").equals("")){
				nodevalues.put("showadd", "none");//不显示“添加”
				nodevalues.put("cardurl","xxx");
			}else{
				cardurl = frontprojectSvrUrl + "/" + nodevalues.get("frontprojectname") + "/#/"+nodevalues.get("cardurl");
				nodevalues.put("showadd", "block");//显示“添加”
				nodevalues.put("cardurl",cardurl);
			}
			if(nodevalues.get("diviconfont")==null || nodevalues.get("diviconfont").equals("")){
				nodevalues.put("diviconfont","&#xe600;");
			}
			if(nodevalues.get("divclass")==null || nodevalues.get("divclass").equals("")){
				nodevalues.put("divclass","patch-device");
			}
			if(nodevalues.get("listid")==null || nodevalues.get("listid").equals("")){
				nodevalues.put("listid",nodevalues.get("nodecode") + "list");
			}
			if(nodevalues.get("addid")==null || nodevalues.get("addid").equals("")){
				nodevalues.put("addid",nodevalues.get("nodecode") + "add");
			}
		}else{//优办云待确认
			if(nodevalues.get("listurl")== null || nodevalues.get("listurl").equals("")){
				listurl = moblieofficeSvrUrl + "/mobile/#/pub/portalWidget/newsWidget/newsWidget";

			}else{
				listurl = moblieofficeSvrUrl + "/apps/mobileOffice/#/"+nodevalues.get("innerdivid");
			}
			
		}
		
		String strXML = ReadFile(filepath);
				
		return ReplaceAllByMap(strXML, nodevalues);
		
	}
	
	/**
	 * 根据nodecode获取配置信息
	 * @param nodecode
	 * @return
	 */
	private Map<String,Object> findModelByCode(String nodecode){
		String sql = "select * from pub_portalnode where nodecode=:nodecode";
		Map<String, Object> paras = new HashMap<String, Object>();
		paras.put("nodecode", nodecode);
		List<PortalNodeVO>  list = queryDao.findListBySql(sql, paras,PortalNodeVO.class);
		Map<String,Object> model = new HashMap<String,Object>();
		if(list.isEmpty() || list.size()!= 1){
			return null;
		}
		for(PortalNodeVO vo:list){
			model.put(PortalNodeVO.NODECODE, vo.getNodecode());
			model.put(PortalNodeVO.NODENAME, vo.getNodename());	
			model.put(PortalNodeVO.XMLTEMPLATE, vo.getXmltemplate());
			model.put(PortalNodeVO.DIVID, vo.getDivid());
			model.put(PortalNodeVO.DIVCLASS, vo.getDivclass());
			model.put(PortalNodeVO.DIVICONFONT, vo.getDiviconfont());
			model.put(PortalNodeVO.DIVSPANNUM,  vo.getDivspannum());
			model.put(PortalNodeVO.DIVSPANUNIT, vo.getDivspanunit());
			model.put(PortalNodeVO.LISTID, vo.getListid());
			model.put(PortalNodeVO.ADDID, vo.getAddid());
			model.put(PortalNodeVO.FRONTPROJECTNAME, vo.getFrontprojectname());
			model.put(PortalNodeVO.BACKPROJECTNAME, vo.getBackprojectname());
			model.put(PortalNodeVO.LISTURL, vo.getListurl());
			model.put(PortalNodeVO.CARDURL, vo.getCardurl());
			model.put(PortalNodeVO.ISMOBILE, vo.getIsmobile());
		}
		return model;
		
	}
	
	/**
	 * 根据配置信息替换xml中的变量
	 * @param strXML
	 * @param replaceKeys
	 * @return
	 */
	private String ReplaceAllByMap(String strXML, Map<String,Object> replaceKeys){
		for(Entry<String, Object> entry:replaceKeys.entrySet()){ 
			
			if(entry.getValue()!= null){
				strXML = strXML.replaceAll("\\$\\$"+entry.getKey()+"\\$\\$", entry.getValue().toString());
			}else{
				strXML = strXML.replaceAll("\\$\\$"+entry.getKey()+"\\$\\$", null);
			}
   
		}   
		return strXML;
	}

	/**
	 * 读取xml模版
	 * @param filepath
	 * @return
	 */
	private String ReadFile(String filepath){
		try{
			 /* 读入TXT文件 */  
	        //String pathname = "D:\\twitter\\13_9_6\\dataset\\en\\input.txt"; // 绝对路径或相对路径都可以，这里是绝对路径，写入文件时演示相对路径  
	        File filename = new File(filepath); // 要读取以上路径的input。txt文件  
	        InputStreamReader reader = new InputStreamReader(  
	                new FileInputStream(filename),"UTF-8"); // 建立一个输入流对象reader  
	        BufferedReader br = new BufferedReader(reader); // 建立一个对象，它把文件内容转成计算机能读懂的语言  
	        String line = "";  
	        StringBuffer sb = new StringBuffer();
	        String lineSeparator = System.getProperty("line.separator");
	        line = br.readLine();  
	        if(line!=null)
	        	sb.append(line);
	        while (line != null) {  
	            line = br.readLine(); // 一次读入一行数据 
	            if(line!=null)
		        	sb.append(lineSeparator + line);
	        } 
	        return sb.toString();
		} catch (Exception e) {  
           e.printStackTrace();  
           return null;
       } 
	}
}
