package com.yyjz.icop.pub.utils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 高级筛选条件 解析工具类
 * @author ktao
 *
 */
public class AdvanceSearchUtil {

	/**
	 * 高级条件解析一年四个季度
	 * @param fieldName
	 * @param lstInValue
	 * @return
	 */
	public static String getSqlquarter(String fieldName, String[] lstInValue, String fieldBefore){
		StringBuilder sql = new StringBuilder();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
		Date date = new Date();
		String cyear = sdf.format(date);
		String beginDate = "";
		String endDate = "";
		for(String v : lstInValue){
			switch (v) {
			case "1quarter":
				beginDate = cyear + "-01-01";
				endDate = cyear + "-04-01";
				break;
			case "2quarter":
				beginDate = cyear + "-04-01";
				endDate = cyear + "-07-01";
				break;
			case "3quarter":
				beginDate = cyear + "-07-01";
				endDate = cyear + "-10-01";
				break;
			case "4quarter":
				beginDate = cyear + "-10-01";
				endDate = String.valueOf(Integer.parseInt(cyear)+1) + "-01-01";
				break;
			default:
				break;
			}
			if(sql.length()>0){
				sql.append(" or ");
			}
			sql.append("(");
			sql.append(sqlUnionByopt(fieldName, ">=" , beginDate, fieldBefore));
			sql.append(" and ");
			sql.append(sqlUnionByopt(fieldName, "<" , endDate, fieldBefore));
			sql.append(")");
		}
		sql.insert(0, "(");
		sql.append(")");
		return sql.toString();
	}
	
	/**
	 * 组装sql，数组型值，   = like  in 
	 * @param fieldName
	 * @param opt
	 * @param values
	 * @return
	 */
	public static String sqlUnionByList(String fieldName, String opt ,String[] values, String fieldBefore){
		List<String> sqlv = new ArrayList<String>();
		
		for(String v : values){
			String sql = "";
			if(opt.equals("=") || opt.equals("like") || opt.equals(" "))
				sql += fieldBefore + fieldName + " " + opt + " ";			
			v =  v.replace("'", "''");
			if(opt.equals("like"))
				v = "%" + v + "%";
			if(!opt.equals(" "))
				v = "'" + v + "'";
			sqlv.add(sql + v);
		}
		StringBuilder sqlall = new StringBuilder();
		for(String sql : sqlv){
			if(sqlall.length()>0){
				if(opt.equals("=") || opt.equals("like") || opt.equals(" "))
					sqlall.append(" or ");
				else
					sqlall.append(" , ");
			}
			sqlall.append(sql);
		}
		return sqlall.toString();
	}
	
	/**
	 * 按操作符拼装sql
	 * @param fieldName
	 * @param opt
	 * @param value
	 * @return
	 */
	public static String sqlUnionByopt(String fieldName, String opt ,String value, String fieldBefore){
		if(opt.equals("include")){
			return "(" + fieldBefore + fieldName + " like '%" + value.replace("'", "''") + "%')";
		}else if(opt.equals("notInclude")){
			return "(" + fieldBefore + fieldName + " NOT LIKE '%" + value.replace("'", "''") + "%')";
		}else if(opt.equals("rightInclude")){
			return "(" + fieldBefore + fieldName + " LIKE '" + value.replace("'", "''") + "%')";
		}else if(opt.equals("leftInclude")){
			return "(" + fieldBefore + fieldName + " LIKE '" + value.replace("'", "''") + "%')";
		}else if(opt.equals("equal")){
			return "(" + fieldBefore + fieldName + " = '" + value.replace("'", "''") + "')";
		}else if(opt.equals("notEqual")){
			return "(" + fieldBefore + fieldName + " <> '" + value.replace("'", "''") + "')";
		}else if(opt.equals("<=") || opt.equals(">=") || opt.equals("=") || opt.equals("<") || opt.equals(">")){
			return "(" + fieldBefore + fieldName + " "+ opt +" '" + value.replace("'", "''") + "')";
		}else{
			//logger.error("高级筛选条件异常，无法识别的比较符：" + opt);
			return null;
		}
	}
}
