package com.yyjz.icop.pub.utils;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.alibaba.fastjson.JSONObject;
import com.yyjz.icop.context.UserContext;
import com.yyjz.icop.exception.BusinessException;

/**
 *
 * @ClassName: AppContext 
 * @Description: 应用上下文
 * @author liYang liyangs@yonyou.com 
 * @date 2016年11月23日 下午5:17:36    
 */
public final class AppContext {
	
	private final static Logger logger = LoggerFactory.getLogger(AppContext.class);

	private AppContext() {
	}

	private static Boolean isNull(JSONObject o) {
		return o == null || o.isEmpty();
	}
	
	private static String getUserInfo(String infoName){
		JSONObject user = null;
		try{
			logger.debug("UserContext.getUserDetail():"+ UserContext.getUserDetail().toJSONString());
			user =	(JSONObject) UserContext.getUserDetail().get("user");
		}catch(Exception e){
			logger.error("后端调用UserContext.getUserDetail()方法获取登录上下文用户信息失败，请检查平台获取上下文服务,",e.getCause());
			throw new BusinessException("后端获取平台上下文失败，请确认您已登陆或联系平台解决");
		}
		if(isNull(user) || StringUtils.isBlank(user.getString(infoName))){
			logger.error("后端调用UserContext.getUserDetail()方法获取登录上下文用户信息失败，请检查平台获取上下文服务");
			throw new BusinessException("后端获取平台上下文失败，请确认您已登陆或联系平台解决");
		}
		logger.debug("从平台上下文中获取的"+ infoName +"是："+ user.getString(infoName));
		return user.getString(infoName);
	}
	
	private static String getSupplierInfo(String infoName){
		JSONObject supplier = null;
		try{
			logger.debug("UserContext.getSupplier():"+ UserContext.getSupplier().toJSONString());
			supplier = UserContext.getSupplier().getJSONObject("data");
		}catch(Exception e){
			logger.error("后端调用UserContext.getSupplier()方法获取登录上下文供应商信息失败，请检查平台获取上下文服务,",e);
			throw new BusinessException("后端获取平台上下文失败，请确认您已登陆或联系平台解决");
		}
		if(isNull(supplier) || StringUtils.isBlank(supplier.getString(infoName))){
			logger.error("后端调用UserContext.getSupplier()方法获取登录上下文供应商信息失败，请检查平台获取上下文服务");
			throw new BusinessException("后端获取平台上下文失败，请确认您已登陆或联系平台解决");
		}
		logger.debug("从平台上下文中获取的"+ infoName +"是："+ supplier.getString(infoName));
		return supplier.getString(infoName);
	}

	/**
	 *
	 * @Title: getUserId 
	 * @Description: 获取用户Id
	 * @param
	 * @return @throws 
	 */
	public static String getUserId() {
		return getUserInfo("userId");
	}

	/**
	 *
	 * @Title: getUserName 
	 * @Description: 获取用户名称
	 * @param
	 * @return @throws 
	 */
	public static String getUserName() {
		return getUserInfo("userName");
	}

	/**
	 *
	 * @Title: getUserType 
	 * @Description: 获取用户类型
	 * @param
	 * @return @throws 
	 */
	public static String getUserType() {
		return getUserInfo("userType");
	}

	/**
	 *
	 * @Title: getUserCode 
	 * @Description: 获取用户编码
	 * @param
	 * @return @throws 
	 */
	public static String getUserCode() {
		return getUserInfo("userCode");
	}

	/**
	 *
	 * @Title: getTenantId 
	 * @Description: 获取租户Id
	 * @param
	 * @return @throws 
	 */
	public static String getTenantId() {
		return getUserInfo("tenantId");
	}

	/**
	 *
	 * @Title: getLogints 
	 * @Description: 获取登录时间戳
	 * @param
	 * @return @throws 
	 */
	public static String getLogints() {
		return getUserInfo("logints");
	}

	/**
	 *
	 * @Title: getSupplierId 
	 * @Description: 获取供应商ID
	 * @param
	 * @return @throws 
	 */
	public static String getSupplierId() {
		return getSupplierInfo("id");
	}

	/**
	 *
	 * @Title: getSupplierCode 
	 * @Description: 获取供应商code
	 * @param
	 * @return @throws 
	 */
	public static String getSupplierCode() {
		return getSupplierInfo("code");
	}

	/**
	 *
	 * @Title: getSupplierName 
	 * @Description: 获取供应商名称
	 * @param
	 * @return @throws 
	 */
	public static String getSupplierName() {
		return getSupplierInfo("name");
	}

	/**
	 *
	 * @Title: getStaffId 
	 * @Description: 获取人员ID
	 * @param
	 * @return @throws 
	 */
	public static String getStaffId() {
		if (isNull(UserContext.getStaff()))
			return null;
		if (isNull(UserContext.getStaff().getJSONObject("data")))
			return null;
		return UserContext.getStaff().getJSONObject("data").getString("id");
	}

	/**
	 *
	 * @Title: getStaffCode 
	 * @Description: 获取人员code
	 * @param
	 * @return @throws 
	 */
	public static String getStaffCode() {
		if (isNull(UserContext.getStaff()))
			return null;
		if (isNull(UserContext.getStaff().getJSONObject("data")))
			return null;
		return UserContext.getStaff().getJSONObject("data").getString("code");
	}

	/**
	 *
	 * @Title: getStaffName 
	 * @Description: 获取人员名称
	 * @param
	 * @return @throws 
	 */
	public static String getStaffName() {
		if (isNull(UserContext.getStaff()))
			return null;
		if (isNull(UserContext.getStaff().getJSONObject("data")))
			return null;
		return UserContext.getStaff().getJSONObject("data").getString("name");
	}

	/**
	 *
	 * @Title: getDeptId 
	 * @Description: 获取部门ID
	 * @param
	 * @return @throws 
	 */
	public static String getDeptId() {
		if (isNull(UserContext.getDept()))
			return null;
		if (isNull(UserContext.getDept().getJSONObject("data")))
			return null;
		return UserContext.getDept().getJSONObject("data").getString("id");
	}

	/**
	 *
	 * @Title: getDeptCode 
	 * @Description: 获取部门code
	 * @param
	 * @return @throws 
	 */
	public static String getDeptCode() {
		if (isNull(UserContext.getDept()))
			return null;
		if (isNull(UserContext.getDept().getJSONObject("data")))
			return null;
		return UserContext.getDept().getJSONObject("data").getString("code");
	}

	/**
	 *
	 * @Title: getDeptName 
	 * @Description: 获取部门名称
	 * @param
	 * @return @throws 
	 */
	public static String getDeptName() {
		if (isNull(UserContext.getDept()))
			return null;
		if (isNull(UserContext.getDept().getJSONObject("data")))
			return null;
		return UserContext.getDept().getJSONObject("data").getString("name");
	}

	/**
	 *
	 * @Title: getCurCompanyId 
	 * @Description: 获取当前组织ID
	 * @param
	 * @return @throws 
	 */
	public static String getCurCompanyId() {
		if (isNull(UserContext.getCurCompany()))
			return null;
		return UserContext.getCurCompany().getString("companyId");
	}

	/**
	 *
	 * @Title: getCurCompanyCode 
	 * @Description: 获取当前组织code
	 * @param
	 * @return @throws 
	 */
	public static String getCurCompanyCode() {
		if (isNull(UserContext.getCurCompany()))
			return null;
		return UserContext.getCurCompany().getString("companyCode");
	}

	/**
	 *
	 * @Title: getCurCompanyName 
	 * @Description: 获取当前组织名称
	 * @param
	 * @return @throws 
	 */
	public static String getCurCompanyName() {
		if (isNull(UserContext.getCurCompany()))
			return null;
		return UserContext.getCurCompany().getString("companyName");
	}

}
