package com.yyjz.icop.pub.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 *
 * @ClassName: DateUtils 
 * @Description: 当前系统标准时间转换
 * @author liYang liyangs@yonyou.com 
 * @date 2016年12月6日 上午10:07:58 
 *  
 */
public class DateUtils {
	
	private static final SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	
	/**
	 *
	 * @Title: toStdDate 
	 * @Description: 转换为日期
	 * @param 
	 * @return 
	 * @throws 
	 */
	public static Date toStdDate(String dateStr) throws ParseException{
		return dateFmt.parse(dateStr);
	}
	
	/**
	 *
	 * @Title: toStdDateString 
	 * @Description: 转换为字符串
	 * @param 
	 * @return 
	 * @throws 
	 */
	public static String toStdDateString(Date date){
		return dateFmt.format(date);
	}
	
	/**
	 *
	 * @Title: toStdCrtDateString 
	 * @Description: 当前日期转换为字符串
	 * @param 
	 * @return 
	 * @throws 
	 */
	public static String toStdCrtDateString(){
		return dateFmt.format(new Date());
	}

}
