package com.yyjz.icop.pub.utils;

import java.io.IOException;
import java.net.URLDecoder;
import java.security.GeneralSecurityException;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.httpclient.HttpStatus;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yyjz.icop.application.utils.HttpClientWarperUtils;
import com.yyjz.icop.exception.BusinessException;

@SuppressWarnings("deprecation")
public class HttpRequestUtils {
	private static Logger logger = LoggerFactory.getLogger(HttpRequestUtils.class); // 日志记录

	/**
	 * httpPost
	 * 
	 * @param url
	 *            路径
	 * @param jsonParam
	 *            参数
	 * @return
	 */
	public static JSONObject httpPost(String url, JSONObject jsonParam, HttpServletRequest req) {
		return httpPost(url, jsonParam, req, false);
	}

	/**
	 * post请求
	 * 
	 * @param url
	 *            url地址
	 * @param jsonParam
	 *            参数
	 * @param noNeedResponse
	 *            不需要返回结果
	 * @return
	 */
	public static JSONObject httpPost(String url, JSONObject jsonParam, HttpServletRequest req,
			boolean noNeedResponse) {

		// Map<String, String> params =
		// JSONObject.parseObject(jsonParam.toJSONString(),
		// new TypeReference<Map<String, String>>() {
		// });
		//
		// Map<String, String> headers = new HashMap<String, String>();
		//
		// headers.put("authority", req.getHeader("authority"));
		// headers.put("icop-token", req.getHeader("icop-token"));
		JSONObject jsonResult = null;
		// try {
		// String str = HttpClientWarperUtils.postFormByJson(url, params,
		// headers);
		// jsonResult = JSON.parseObject(str);
		// } catch (ConnectTimeoutException e) {
		// logger.error("post请求提交失败:" + url, e);
		// throw new BusinessException("404, 不能连接到目标服务器!");
		//
		// } catch (SocketTimeoutException e) {
		// logger.error("post请求提交失败:" + url, e);
		// throw new BusinessException("404, 不能连接到目标服务器!");
		// } catch (Exception e) {
		// logger.error("post请求提交失败:" + url, e);
		// throw new BusinessException("404, 不能连接到目标服务器!");
		// }

		// post请求返回结果
		// DefaultHttpClient httpClient = new DefaultHttpClient();
		// HttpClient httpClient = new HttpClient();
		CloseableHttpClient httpClient = null;

		if (url.startsWith("https")) {
			// 执行 Https 请求.
			try {
				httpClient = HttpClientWarperUtils.createSSLInsecureClient();
			} catch (GeneralSecurityException e1) {
				throw new BusinessException("404, 不能连接到目标服务器!");
			}
		} else {
			// 执行 Http 请求.
			//httpClient = new DefaultHttpClient();
			PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
			cm.setMaxTotal(128);
			cm.setDefaultMaxPerRoute(128);
			httpClient = HttpClients.custom().setConnectionManager(cm).build();
		}

		HttpPost method = new HttpPost(url);
		try {
			if (null != jsonParam) {
				// 解决中文乱码问题
				StringEntity entity = new StringEntity(jsonParam.toString(), "utf-8");
				entity.setContentEncoding("UTF-8");
				entity.setContentType("application/json");
				method.setEntity(entity);
				method.addHeader("authority", req.getHeader("authority"));
				method.addHeader("icop-token", req.getHeader("icop-token"));
			}
			HttpResponse result = httpClient.execute(method);
			url = URLDecoder.decode(url, "UTF-8");
			/** 请求发送成功，并得到响应 **/
			if (result.getStatusLine().getStatusCode() == 200) {
				// String str = "";
				try {
					/** 读取服务器返回过来的json字符串数据 **/
					String str = EntityUtils.toString(result.getEntity());
					if (noNeedResponse) {
						return null;
					}
					/** 把json字符串转换成json对象 **/
					jsonResult = JSON.parseObject(str);
				} catch (Exception e) {
					logger.error("post请求提交失败:" + url, e);
				}
			} else if (result.getStatusLine().getStatusCode() == 404) {
				throw new BusinessException("404, 不能连接到目标服务器!");
			}
		} catch (IOException e) {
			logger.error("post请求提交失败:" + url, e);
		}
		return jsonResult;
	}

	/**
	 * 发送get请求
	 * 
	 * @param url
	 *            路径
	 * @return
	 */
	public static JSONObject httpGet(String url) {
		// get请求返回结果
		JSONObject jsonResult = null;
		try {
			DefaultHttpClient client = new DefaultHttpClient();
			// 发送get请求
			HttpGet request = new HttpGet(url);
			HttpResponse response = client.execute(request);

			/** 请求发送成功，并得到响应 **/
			if (response.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
				/** 读取服务器返回过来的json字符串数据 **/
				String strResult = EntityUtils.toString(response.getEntity());
				/** 把json字符串转换成json对象 **/
				jsonResult = JSON.parseObject(strResult);
				;
				url = URLDecoder.decode(url, "UTF-8");
			} else {
				logger.error("get请求提交失败:" + url);
			}
		} catch (IOException e) {
			logger.error("get请求提交失败:" + url, e);
		}
		return jsonResult;
	}
}