package com.yyjz.icop.pub.utils;

public class JsonBackData {
	/**
	 * 操作是否成功
	 */
	private boolean success;
	/**
	 * 操作返回的提示信息
	 */
	private String backMsg;
	/**
	 * 操作返回的数据
	 */
	private Object backData;

	public JsonBackData() {
		this.success = true;
	}

	public boolean isSuccess() {
		return success;
	}

	public void setSuccess(boolean success) {
		this.success = success;
	}

	public String getBackMsg() {
		return backMsg;
	}

	public void setBackMsg(String backMsg) {
		this.backMsg = backMsg;
	}

	public Object getBackData() {
		return backData;
	}

	public void setBackData(Object backData) {
		this.backData = backData;
	}
	
	//addBy liYang liyangs@yonyou.com 2016/7/29 begin
	private JsonBackData(boolean success, String backMsg, Object backData) {
		super();
		this.success = success;
		this.backMsg = backMsg;
		this.backData = backData;
	}
	
	public static JsonBackData success(){
		return new JsonBackData(true, null, null);
	}
	
	public static JsonBackData success(String msg){
		return new JsonBackData(true, msg, null);
	}
	
	public static JsonBackData successRtnObject(Object data){
		return new JsonBackData(true, null, data);
	}
	
	public static JsonBackData fail(){
		return new JsonBackData(false, null, null);
	}
	
	public static JsonBackData fail(String msg){
		return new JsonBackData(false, msg, null);
	}
	
	public static JsonBackData failRtnObject(Object data){
		return new JsonBackData(false, null, data);
	}
	
	public  static JsonBackData getInstance(boolean flag, String msg, Object data){
		return new JsonBackData(flag, msg, data);
	}
	
	//addBy liYang liyangs@yonyou.com 2016/7/29 end
}
