package com.yyjz.icop.pub.utils;

import java.math.BigDecimal;

/**
 * 数学计算工具
 * 
 * @author Zhi
 * @time 2016年6月7日14:07:32
 *
 */
public class MathUtil {
	/**
	 * 2个BigDecimal类型相加
	 * 
	 * @param a
	 * @param b
	 * @return
	 */
	public static BigDecimal add(BigDecimal a, BigDecimal b) {
		if (a == null) {
			return b;
		} else if (b == null) {
			return a;
		}
		return a.add(b);
	}

	/**
	 * 2个Double类型相加
	 * 
	 * @param a
	 * @param b
	 * @return
	 */
	public static Double add(Double a, Double b) {
		if (a == null) {
			return b;
		} else if (b == null) {
			return a;
		}
		BigDecimal ta = new BigDecimal(Double.toString(a));
		BigDecimal tb = new BigDecimal(Double.toString(b));
		return ta.add(tb).doubleValue();
	}

	/**
	 * 2个BigDecimal类型相减
	 * 
	 * @param a
	 * @param b
	 * @return
	 */
	public static BigDecimal sub(BigDecimal a, BigDecimal b) {
		if (a == null) {
			return b;
		} else if (b == null) {
			return a;
		}
		return a.subtract(b);
	}

	public static BigDecimal mult(BigDecimal a, BigDecimal b) {
		if (a == null || b == null) {
			return null;
		}
		return a.multiply(b);
	}
	
	public static Double mult(Double a, Double b) {
		if (a == null || b == null) {
			return null;
		}
		BigDecimal ta = new BigDecimal(Double.toString(a));
		BigDecimal tb = new BigDecimal(Double.toString(b));
		return ta.multiply(tb).doubleValue();
	}

    public static BigDecimal devide(BigDecimal a, BigDecimal b, int precision, int roundType) {
        if (a == null || b == null|| b.compareTo(new BigDecimal(0))==0) {
            return null;
        }
        return a.divide(b, precision, roundType);
    }
    
    public static Double devide(Double a, Double b, int precision, int roundType) {
        if (a == null || b == null||b==0) {
            return null;
        }
        
        BigDecimal ta = new BigDecimal(Double.toString(a));
		BigDecimal tb = new BigDecimal(Double.toString(b));
        return ta.divide(tb, precision, roundType).doubleValue();
    }
}
