package com.yyjz.icop.pub.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;

/**
 * <strong>简化结果集映射</strong>
 * 
 * @ClassName: PageMap2VoConverter
 * @Description: 查询结果Page(Map)到Page(VO)的映射
 * @author LiYang liyangs@yonyou.com
 * @date 2016年8月2日 上午09:50:51
 *
 */
public abstract class PageMap2VoConverter<T> {
	
	@SuppressWarnings("rawtypes")
	public boolean validate(Page<Map> page){
		if(page == null )
			return false;
		if(!page.hasContent())
			return false;
		if(page.getTotalElements() < 1 )
			return false;
		return true;
	};
	
	@SuppressWarnings("rawtypes")
	public Page<T> convert(Page<Map> map){
		if(validate(map))
			return convertInternal(map);
		else {
			return new PageImpl<>(new ArrayList<T>(0));
		}
	}
	
	/**
	 * --不想写这个，后续(应该)会优化--<br>
	 * <br>
	 * <strong>耗时，慎用</strong>
	 * @param map
	 * @param c
	 * @return
	 * @throws IllegalAccessException 
	 * @throws IllegalArgumentException 
	 * @throws InstantiationException 
	 */
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public Page<T> convert(Page<Map> pagemap, Class<T> c) throws IllegalArgumentException, IllegalAccessException, InstantiationException{
		if(validate(pagemap)){
			Iterator<Map> it = pagemap.iterator();
			List<T> list = new ArrayList<T>();
			while (it.hasNext()) {
				Map map = it.next();
				T vo = (T) c.getClass().newInstance();
				Field[] fields = c.getClass().getDeclaredFields();
				for (Field field : fields) {
					Object v = null;
					if(map.containsKey(field.getName())){
						v = map.get(field.getName());
					} else if(map.containsKey(field.getName().toUpperCase())){
						v = map.get(field.getName().toUpperCase());
					}else if(map.containsKey(field.getName().toLowerCase())){
						v = map.get(field.getName().toLowerCase());
					}else {
						continue;
					}
					if(v != null ){
						field.setAccessible(true);
						field.set(vo, v);
					}
				}
				list.add(vo);
			}
			return new PageImpl<T>(list, null , pagemap.getTotalElements());
		}else {
			return new PageImpl<>(new ArrayList<T>(0));
		}
	}
	
	/**
	 * <strong>推荐使用bean中加静态属性属性名的方式完成映射</strong>
	 * <br>
	 * <br>
	 * eg: <br>
	 * private String userName;<br>
	 * public static String USERNAME = "userName"<br>
	 * {<br>
	 * user.serUserName(usermap.get(User.USERNAME))<br>
	 * }<br>
	 * @param map 具体映射方式
	 * @return 返回结果集
	 */
	@SuppressWarnings("rawtypes")
	protected abstract Page<T> convertInternal(Page<Map> map);
	
}
