package com.yyjz.icop.pub.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.hibernate.collection.internal.PersistentBag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

import com.yyjz.icop.pub.base.entity.BaseIdEntity;
import com.yyjz.icop.pub.base.vo.SuperVO;

/**
 * 复制主实体/关联实体/关联集合实体 <br>
 * <br>
 * <strong>非常耗费资源，慎重使用</strong>
 *
 * @ClassName: SimpleBeanUtils 
 * @Description:
 * @author liYang liyangs@yonyou.com 
 * @date 2016年7月25日 下午7:30:18 
 * @version 0.1   
 */
public class SimpleBeanUtils {

	private static Logger logger = LoggerFactory.getLogger(SimpleBeanUtils.class);

	@SuppressWarnings({ "rawtypes", "unchecked" })
	@Deprecated
	public static Object convert(Object src, Object dest, Map<String, Class> mapper, String[] excludes) {
		try {
			// 普通屬性copy
			BeanUtils.copyProperties(src, dest);
			logger.info("复制实体：" + src.getClass().getSimpleName() + " 结束");
			for (Field destField : dest.getClass().getDeclaredFields()) {
				// 普通对象
				// 如果目标类的属性中有关联的实体对象，则复制它
				if (SuperVO.class.isAssignableFrom(destField.getType())
						|| BaseIdEntity.class.isAssignableFrom(destField.getType())) {
					destField.setAccessible(true);
					Object o = destField.getType().newInstance();
					Field tfield = src.getClass().getDeclaredField(destField.getName());
					tfield.setAccessible(true);
					BeanUtils.copyProperties(tfield.get(src), o);
					for (Field f : o.getClass().getDeclaredFields()) {
						if (excludes != null && Arrays.asList(excludes).contains(f.getName())) {
							f.set(dest, null);
						}
						if (SuperVO.class.isAssignableFrom(f.getType())
								|| BaseIdEntity.class.isAssignableFrom(f.getType())) {
							f.setAccessible(true);
							f.set(o, null);
						}
					}
					destField.set(dest, o);
					logger.info("复制关系实体：" + destField.getType().getName() + " 结束");
					continue;
				}
				// 如果目标类中有集合关联的实体对象，则复制它
				if (Collection.class.isAssignableFrom(destField.getType())) {
					// 获取源对象的集合属性
					Field sfield = src.getClass().getDeclaredField(destField.getName());
					sfield.setAccessible(true);
					Collection scl = (Collection) sfield.get(src);
					// 获取目标对象的集合属性
					destField.setAccessible(true);
					Collection tcl = (Collection) destField.get(dest);
					if (mapper != null && mapper.containsKey(destField.getName())) {
						Class c = mapper.get(destField.getName());
						for (Object object : scl) {
							Object po = c.newInstance();
							BeanUtils.copyProperties(object, po);
							for (Field f : po.getClass().getDeclaredFields()) {
								if (SuperVO.class.isAssignableFrom(f.getType())
										|| BaseIdEntity.class.isAssignableFrom(f.getType())) {
									f.setAccessible(true);
									f.set(po, null);
								}
							}
							tcl.add(po);
						}
					}
					// tcl.clear();

				}
			}

		} catch (Exception e) {
			throw new RuntimeException(e.getCause());
		}
		return dest;
	}

	/**
	 * 
	 *
	 * @Title: copyProperties 
	 * @Description: 复制源对象的属性到目标对象，包括源对象的基本属性，实体属性，集合属性
	 * @param source
	 *            源对象
	 * @param target
	 *            目标对象
	 * @param mapper
	 *            集合属性的属性名-集合对象类型映射
	 * @param excludes
	 *            忽略的属性名(包括源对象、源对象的关联对象、源对象的集合属性的对象)
	 * @return @throws 
	 */
	@SuppressWarnings({ "rawtypes", "unchecked", "unused" })
	public static void copyProperties(Object source, Object target, Map<String, Class> mapper, String[] excludes) {
		logger.info("复制属性开始...");
		long start = System.currentTimeMillis();
		try {
			BeanUtils.copyProperties(source, target, excludes);
			for (Field targetField : target.getClass().getDeclaredFields()) {
				// 如果属性为关联的实体对象，则复制它
				if (SuperVO.class.isAssignableFrom(targetField.getType())
						|| BaseIdEntity.class.isAssignableFrom(targetField.getType())) {
					if (!Modifier.isPublic(targetField.getModifiers())) {
						targetField.setAccessible(true);
					}
					Object o = targetField.getType().newInstance();
					Field sourceField = source.getClass().getDeclaredField(targetField.getName());
					if (!Modifier.isPublic(sourceField.getModifiers())) {
						sourceField.setAccessible(true);
					}
					BeanUtils.copyProperties(sourceField.get(source), o, excludes);
					targetField.set(target, o);
					continue;
				}
				// 如果目标类中有关联的集合实体对象，则复制它
				if (Collection.class.isAssignableFrom(targetField.getType())) {
					// 获取目标对象的集合属性
					if (!Modifier.isPublic(targetField.getModifiers())) {
						targetField.setAccessible(true);
					}
					Collection tcl = (Collection) targetField.get(target);
					// 获取源对象的集合属性
					Field sourceField = source.getClass().getDeclaredField(targetField.getName());
					if (!Modifier.isPublic(sourceField.getModifiers())) {
						sourceField.setAccessible(true);
					}
					Collection scl = (Collection) sourceField.get(source);
					// 属性复制
					if (mapper != null && mapper.containsKey(targetField.getName())) {
						Collection list = null;
						if (Set.class.isAssignableFrom(targetField.getType())
								|| Set.class.getName().equals(targetField.getType().getName()))
							list = new HashSet();
						else if (List.class.isAssignableFrom(targetField.getType())
								|| List.class.getName().equals(targetField.getType().getName()))
							list = new ArrayList();
						Class c = mapper.get(targetField.getName());
						for (Object object : scl) {
							Object po = c.newInstance();
							BeanUtils.copyProperties(object, po, excludes);
							list.add(po);
						}
						targetField.set(target, list);
					}
				}
			}
		} catch (Exception e) {
			throw new RuntimeException("复制属性未完成", e.getCause());
		}
		long end = System.currentTimeMillis();
		logger.info("复制属性结束...,用时：" + (end - start) + "ms");
	}

	@SuppressWarnings({ "rawtypes", "unchecked", "unused" })
	public static void copyProperties(Object source, Object target, String[] excludes) {
		logger.info("复制属性开始...");
		long start = System.currentTimeMillis();
		try {
			BeanUtils.copyProperties(source, target, excludes);
			Field[] sfs = source.getClass().getDeclaredFields();
			List<String> sfNames = new ArrayList<>();
			for (Field f : sfs) {
				sfNames.add(f.getName());
			}
			for (Field targetField : target.getClass().getDeclaredFields()) {
				if(! sfNames.contains(targetField.getName()))
					continue;
				// 如果属性为关联的实体对象，则复制它
				if (SuperVO.class.isAssignableFrom(targetField.getType())
						|| BaseIdEntity.class.isAssignableFrom(targetField.getType())) {
					if (!Modifier.isPublic(targetField.getModifiers())) {
						targetField.setAccessible(true);
					}
					Object o = targetField.getType().newInstance();
					Field sourceField = source.getClass().getDeclaredField(targetField.getName());
					if (!Modifier.isPublic(sourceField.getModifiers())) {
						sourceField.setAccessible(true);
					}
					BeanUtils.copyProperties(sourceField.get(source), o, excludes);
					targetField.set(target, o);
					continue;
				}
				// 如果目标类中有关联的集合实体对象，则复制它
				 else if (Collection.class.isAssignableFrom(targetField.getType())) {
					// 获取目标对象的集合属性
					if (!Modifier.isPublic(targetField.getModifiers())) {
						targetField.setAccessible(true);
					}
					Collection tcl = (Collection) targetField.get(target);
					// 获取集合内对象类型
					Class c = null;
					if (tcl instanceof PersistentBag && ((PersistentBag) tcl).size() > 0) {
						c = (Class) ((PersistentBag) tcl).get(0).getClass();
						if (!SuperVO.class.isAssignableFrom(c) && !BaseIdEntity.class.isAssignableFrom(c)) {
							continue;
						}
					} else {
						continue;
					}
					// 获取源对象的集合属性
					Field sourceField = source.getClass().getDeclaredField(targetField.getName());
					if(sourceField == null)
						continue;
					if (!Modifier.isPublic(sourceField.getModifiers())) {
						sourceField.setAccessible(true);
					}
					Collection scl = (Collection) sourceField.get(source);
					// 属性复制
					Collection list = null;
					if (Set.class.isAssignableFrom(targetField.getType())
							|| Set.class.getName().equals(targetField.getType().getName()))
						list = new HashSet();
					else if (List.class.isAssignableFrom(targetField.getType())
							|| List.class.getName().equals(targetField.getType().getName()))
						list = new ArrayList();
					for (Object object : scl) {
						Object po = c.newInstance();
						BeanUtils.copyProperties(object, po, excludes);
						list.add(po);
					}
					targetField.set(target, list);
				}
			}
		} catch (Exception e) {
			throw new RuntimeException("复制属性未完成", e.getCause());
		}
		long end = System.currentTimeMillis();
		logger.info("复制属性结束...,用时：" + (end - start) + "ms");
	}

}
