package com.yyjz.icop.servlet;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yyjz.icop.exception.BusinessException;
import com.yyjz.icop.pub.base.web.BaseController;
import com.yyjz.icop.pub.utils.JsonBackData;
import com.yyjz.icop.report.ExcelMetadata;

/**
 *
 * @ClassName: ExportExcelFunctionInterceptor 
 * @Description: 导出切面
 * @author liYang liyangs@yonyou.com 
 * @date 2016年12月23日 下午4:15:16 
 *  
 */
public class ExportExcelFunctionInterceptor implements MethodInterceptor {

	private final Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private HttpServletResponse response;

	@Autowired
	private HttpServletRequest request;

	@Override
	public Object invoke(MethodInvocation invocation) throws Throwable {
		Object result = null;
		if (invocation.getMethod().isAnnotationPresent(ExportExcel.class)) {
			String name = invocation.getMethod().getAnnotation(ExportExcel.class).name();
			//请求中有ExportExcel的值，调用导出处理
			if (getParameter(request, invocation.getArguments(), name) != null ) {
				try{
					result = invocation.proceed();
				}catch(Exception e){
					logger.error("导出查询失败", e);
					
					//把异常信息写入excel中
					dealExp("导出查询失败:"+e.getMessage());
					return null;
				}
				
				if(null!=result && result instanceof JsonBackData){
					JsonBackData rt = (JsonBackData) result;
					if(!rt.isSuccess()){
						dealExp(rt.getBackMsg());
						return null;
					}
				}
				
				logger.debug("导出文件请求，处理开始...");
				ExcelMetadata retMate = null;
				BaseController ctl = null;
				if (invocation.getThis() instanceof BaseController) {
					ctl = (BaseController) invocation.getThis();
					retMate = ctl.getExportExcelTitleColumns();
				}
				List<String> properties = new ArrayList<String>();
				if(retMate == null ){
					try {
						JSONArray columns = JSONArray
								.parseArray((String) getParameter(request, invocation.getArguments(), "columnSet"));
						retMate = new ExcelMetadata();
						List<String> labels = new ArrayList<String>();
						for (Object o : columns) {
							JSONObject column = (JSONObject) o;
							if (column.get("template_list_code") != null) {
								if("billState".equals(column.get("template_list_code").toString())){
									properties.add("billStateName");
								}else{
									properties.add(column.get("template_list_code").toString());
								}
								labels.add(column.get("template_list_name") == null ? ""
										: column.get("template_list_name").toString());
							}
						}
						retMate.setLabels(labels);
						//retMate.setProperties(properties);
						// retMate.setModel("");
					} catch (Exception e) {
						logger.error("获取导出数据头失败", e);
						dealExp("获取导出数据头失败:" + e.getMessage());
						throw new BusinessException("获取导出数据头失败: columnSet 失败，请检查是否含该参数或参数格式是否正确");
					}
				}
				try {
					Object res = ((JsonBackData) result).getBackData();
					List exportData = null;
					if(res instanceof Page)
						exportData = ((Page) res).getContent();
					else {
						exportData = (List) res;
					}
					if(null!=ctl){
						List rt = ctl.transExportExcelColumns(exportData,properties);
						retMate.setProperties(properties);
						if(null==rt){
							// TODO 名称暂时用随机字符串，交由前台处理
							ExcelUtils.exportExcel(exportData , response, UUID.randomUUID().toString(), retMate);
						}else{
							ExcelUtils.exportExcel(rt , response, UUID.randomUUID().toString(), retMate);
						}
					}else{
						dealExp("导出失败:控制类为空");
						return result;
					}
				} catch (Exception e) {
					logger.error("导出失败", e);
					dealExp("导出失败:" + e.getMessage());
					throw new BusinessException("导出失败!");
				}
				return null;
			}else {
				result = invocation.proceed();
				return result;
			}
		}else {
			result = invocation.proceed();
			return result;
		}
	}

	private Object getParameter(HttpServletRequest request, Object[] args, String name) {
		if (request.getParameter(name) != null) {
			return request.getParameter(name);
		} else {
			for (int i = 0; i < args.length; i++) {
				if (args[i] instanceof Map) {
					Map map = (Map) args[i];
					return map.get(name);
				}
			}
		}
		return null;
	}
	
	//把异常信息写入excel中
	private void dealExp(String msg){
		List<JsonBackData> expLt = new ArrayList<JsonBackData>();
		JsonBackData jb = new JsonBackData();
		jb.setBackMsg(msg);
		jb.setSuccess(false);
		expLt.add(jb);
		List<String> labels = new ArrayList<String>();
		labels.add("操作返回的提示信息");
		List<String> properties = new ArrayList<String>();
		properties.add("backMsg");
		ExcelMetadata retMate = new ExcelMetadata();
		retMate.setLabels(labels);
		retMate.setProperties(properties);
		ExcelUtils.exportExcel(expLt , response, UUID.randomUUID().toString(), retMate);
	}

}
