/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.uap.tenant.security.factory;

import com.yonyou.iuap.security.rest.api.Signer;
import com.yonyou.iuap.security.rest.common.Credential;
import com.yonyou.iuap.security.rest.digest.client.DigestSigner;
import com.yonyou.iuap.security.rest.exception.UAPSecurityException;
import com.yonyou.iuap.security.rest.rsa.client.RSAClientSigner;
import com.yonyou.iuap.utils.PropertyUtil;
import com.yonyou.uap.tenant.security.factory.ClientCredentialGenerator;
import com.yonyou.uap.tenant.security.factory.ClientParamsProvider;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSignFactory {
    private static final Logger logger = LoggerFactory.getLogger(ClientSignFactory.class);

    public static Signer getSigner() throws UAPSecurityException {
        String signAlg = PropertyUtil.getPropertyByKey((String)"UAP.AUTH.ALG");
        if ("HMAC".equals(signAlg)) {
            return new DigestSigner(ClientCredentialGenerator.loadCredential());
        }
        if ("RSA".equals(signAlg)) {
            return new RSAClientSigner(ClientCredentialGenerator.loadCredential());
        }
        throw new UAPSecurityException("\u7b7e\u540d\u7b97\u6cd5" + signAlg + "\u4e0d\u5339\u914d!");
    }

    public static Signer getSigner(ClientParamsProvider provider) throws UAPSecurityException {
        Credential credential = provider.getCredential();
        String signAlg = provider.getSignAlg();
        if (credential == null || StringUtils.isBlank((String)signAlg)) {
            String msg = "please check params for credential and signalg.";
            logger.error(msg);
            throw new UAPSecurityException(msg);
        }
        if ("HMAC".equals(signAlg)) {
            return new DigestSigner(credential);
        }
        if ("RSA".equals(signAlg)) {
            return new RSAClientSigner(credential);
        }
        throw new UAPSecurityException("\u7b7e\u540d\u7b97\u6cd5" + signAlg + "\u4e0d\u5339\u914d!");
    }
}

