/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.uap.tenant.sign;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestAPIUtils {
    private static final Logger logger = LoggerFactory.getLogger(RestAPIUtils.class);

    public static String encode(String url, String charset) {
        try {
            Matcher matcher = Pattern.compile("[\\u4e00-\\u9fa5]").matcher(url);
            while (matcher.find()) {
                String tmp = matcher.group();
                url = url.replaceAll(tmp, URLEncoder.encode(tmp, charset));
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return url;
    }

    public static long getContentLength(Map<String, ?> paramsMap) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder();
        for (String name : paramsMap.keySet()) {
            if (paramsMap.get(name) instanceof String[]) {
                for (String value : (String[])paramsMap.get(name)) {
                    builder.append(URLEncoder.encode(name, "utf-8"));
                    builder.append('=');
                    builder.append(URLEncoder.encode(value, "utf-8"));
                    builder.append("&");
                }
                builder.delete(builder.length() - 1, builder.length());
            } else {
                builder.append(URLEncoder.encode(name, "utf-8"));
                builder.append('=');
                builder.append(URLEncoder.encode((String)paramsMap.get(name), "utf-8"));
            }
            builder.append('&');
        }
        builder.delete(builder.length() - 1, builder.length());
        byte[] bytes = builder.toString().getBytes("utf-8");
        return bytes.length;
    }
}

