/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.uap.tenant.sign;

import com.yonyou.construction.icop.config.utils.IcopConfigUtils;
import com.yonyou.iuap.security.rest.common.Credential;
import com.yonyou.iuap.security.rest.common.SignProp;
import com.yonyou.iuap.security.rest.utils.PostParamsHelper;
import com.yonyou.iuap.security.rest.utils.SignPropGenerator;
import com.yonyou.uap.tenant.security.factory.ClientSignFactory;
import com.yonyou.uap.tenant.sign.RestAPIUtils;
import com.yonyou.uap.tenant.sign.SignEntity;
import com.yyjz.icop.util.ConfigUtils;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignMake {
    private static Logger log = LoggerFactory.getLogger(SignMake.class);
    public static final String SIGNPOST = "POST";
    public static final String SIGNGET = "GET";
    public static final String SIGNDELETE = "DELETE";
    public static final String PREFIX = "tenant";

    public static String signURL(String reqURL) {
        try {
            reqURL = reqURL.contains("?") ? reqURL + "&" : reqURL + "?";
            reqURL = SignMake.genator(reqURL);
            SignProp prop = SignPropGenerator.genSignProp((String)reqURL);
            String sign = ClientSignFactory.getSigner().sign(prop);
            reqURL = reqURL + "&sign=" + sign;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return reqURL;
    }

    public static SignEntity signEntity(String reqURL, Map<String, ?> paramsMap, String type, String appId) {
        try {
            SignEntity signEntity = new SignEntity();
            reqURL = reqURL.contains("?") ? reqURL + "&" : reqURL + "?";
            reqURL = SignMake.genator(reqURL);
            SignProp prop = SignPropGenerator.genSignProp((String)reqURL);
            if (type.equals(SIGNPOST)) {
                prop.setPostParamsStr(PostParamsHelper.genParamsStrByMap(paramsMap));
                long length = RestAPIUtils.getContentLength(paramsMap);
                prop.setContentLength(length);
            }
            String sign = ClientSignFactory.getSigner().sign(prop);
            signEntity.setSignURL(reqURL);
            signEntity.setSign(sign);
            return signEntity;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String genator(String requestPath) {
        String ts = System.currentTimeMillis() + "";
        requestPath = requestPath + "ts=" + ts;
        Credential credential = SignMake.getCredential();
        String appId = credential.getAppId();
        if (!StringUtils.isNotBlank((String)appId)) {
            log.error("appId is empty");
            return null;
        }
        requestPath = requestPath + "&appId=" + appId;
        return requestPath;
    }

    public static Credential getCredential() {
        String result = null;
        try {
            Properties properties = IcopConfigUtils.getFromServer();
            result = properties.getProperty("appId");
            if (StringUtils.isNotBlank((String)result)) {
                return new Credential(properties.getProperty("appId"), properties.getProperty("key"), properties.getProperty("expiredTs"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isBlank(result) && StringUtils.isNotBlank((String)(result = ConfigUtils.getPropertyByKey("appId")))) {
            return new Credential(ConfigUtils.getPropertyByKey("appId"), ConfigUtils.getPropertyByKey("key"), ConfigUtils.getPropertyByKey("expiredTs"));
        }
        return null;
    }
}

