/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.uap.tenant.web.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yonyou.construction.icop.config.utils.IcopConfigUtils;
import com.yonyou.iuap.security.rest.common.Credential;
import com.yonyou.iuap.security.rest.common.SignProp;
import com.yonyou.iuap.security.rest.exception.UAPSecurityException;
import com.yonyou.iuap.security.rest.factory.ServerVerifyFactory;
import com.yonyou.iuap.security.rest.utils.PostParamsHelper;
import com.yonyou.iuap.security.rest.utils.SignPropGenerator;
import com.yonyou.uap.tenant.entity.SecutityClient;
import com.yyjz.icop.util.ConfigUtils;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import uap.web.utils.HttpTookit;

public class RestFulSecurityFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(RestFulSecurityFilter.class);
    public static RedisTemplate<String, Object> redisTemplate;
    private static final String restfulSecurityUrl = "restful.security.url";

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            ServletContext context = filterConfig.getServletContext();
            WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
            redisTemplate = (RedisTemplate)ctx.getBean("redisTemplate", RedisTemplate.class);
        }
        catch (Exception e) {
            logger.info("\u521d\u59cb\u5316 redisTemplate \u5f02\u5e38!");
            e.printStackTrace();
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            boolean passed;
            HttpServletRequest httpReq = (HttpServletRequest)request;
            if (httpReq.getRequestURI().contains("/uploadavator")) {
                filterChain.doFilter(request, response);
                return;
            }
            String sign = httpReq.getHeader("sign");
            String appid = httpReq.getHeader("appId");
            if (StringUtils.isEmpty((String)sign)) {
                sign = httpReq.getParameter("sign");
            }
            if (StringUtils.isEmpty((String)appid)) {
                appid = httpReq.getParameter("appId");
            }
            if (sign == null || appid == null) {
                logger.error("check sign fail: sign or appid is null");
                HttpServletResponse rp = (HttpServletResponse)response;
                rp.setStatus(400);
                rp.addHeader("restful validate error", " 400 , Method Not Allowed,please check restful called paramters ! ");
                rp.getWriter().write("Method Not Allowed,please check restful called paramters !");
                return;
            }
            String ts = httpReq.getParameter("ts");
            if (StringUtils.isNumeric((String)ts)) {
                long sendTs = Long.parseLong(ts);
                if (System.currentTimeMillis() - sendTs > 300000L) {
                    HttpServletResponse rp = (HttpServletResponse)response;
                    rp.setStatus(400);
                    rp.addHeader("restful validate error", " 400 , \u8bf7\u6c42\u8d85\u65f6");
                    logger.error("restful \u7b7e\u540d\u8d85\u8d85\u65f6");
                    rp.getWriter().write("restful validate over time");
                    return;
                }
            }
            if (!(passed = this.validatorURL(httpReq).booleanValue())) {
                logger.error(MDC.get((String)"callid") + "validator URL fail");
                logger.error("sign:" + httpReq.getHeader("sign"));
                logger.error("paramSign:" + httpReq.getParameter("sign"));
                logger.error("appid:" + httpReq.getParameter("appId"));
                logger.error("url:" + httpReq.getRequestURL().toString());
                logger.error("QueryString:" + httpReq.getQueryString());
                logger.error("Method:" + httpReq.getMethod());
                logger.error("PostParams:" + PostParamsHelper.genParamsStrByReqeust((HttpServletRequest)httpReq));
                logger.error("httpReq.getContentLength():" + httpReq.getContentLength());
                HttpServletResponse rp = (HttpServletResponse)response;
                rp.setStatus(400);
                rp.addHeader("restful validate error", " 400 , Method Not Allowed,please check restful called paramters ! ");
                rp.getWriter().write("Method Not Allowed,please check restful called paramters !");
                return;
            }
        }
        filterChain.doFilter(request, response);
    }

    public void destroy() {
    }

    public Boolean validatorURL(HttpServletRequest httpReq) {
        String sign = httpReq.getHeader("sign");
        if (StringUtils.isEmpty((String)sign)) {
            sign = httpReq.getParameter("sign");
        }
        String appid = httpReq.getParameter("appId");
        sign = StringUtils.isEmpty((String)sign) ? httpReq.getHeader("sign") : sign;
        String string = appid = StringUtils.isEmpty((String)appid) ? httpReq.getHeader("appId") : appid;
        if (StringUtils.isNotEmpty((String)sign) && StringUtils.isNotEmpty((String)appid)) {
            try {
                String url = httpReq.getRequestURL().toString();
                if (StringUtils.isNotBlank((String)httpReq.getQueryString())) {
                    url = url + "?" + httpReq.getQueryString();
                }
                SignProp prop = SignPropGenerator.genSignProp((String)url);
                if (httpReq.getMethod().endsWith("POST")) {
                    prop.setPostParamsStr(PostParamsHelper.genParamsStrByReqeust((HttpServletRequest)httpReq));
                    prop.setContentLength((long)httpReq.getContentLength());
                }
                RestServerVirifyFactory factory = new RestServerVirifyFactory();
                logger.debug(MDC.get((String)"callid") + prop.toString());
                return factory.getVerifier(appid).verify(sign, prop);
            }
            catch (UAPSecurityException e) {
                logger.error("restful\u6458\u8981\u8ba1\u7b97\u5931\u8d25!", (Throwable)e);
            }
            catch (Exception e) {
                logger.error("restful\u6458\u8981\u8ba1\u7b97\u5931\u8d25!", (Throwable)e);
            }
        }
        return false;
    }

    public String getRestFulSecurityUrl() {
        String result = null;
        try {
            Properties properties = IcopConfigUtils.getFromServer();
            result = properties.getProperty(restfulSecurityUrl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isBlank(result)) {
            result = ConfigUtils.getPropertyByKey(restfulSecurityUrl);
        }
        return result;
    }

    class RestServerVirifyFactory
    extends ServerVerifyFactory {
        private Logger log = LoggerFactory.getLogger(ServerVerifyFactory.class);

        RestServerVirifyFactory() {
        }

        protected Credential genCredential(String appId) {
            try {
                ObjectMapper mapper;
                String restUrl;
                SecutityClient sc = (SecutityClient)redisTemplate.opsForValue().get((Object)appId);
                if (sc == null && StringUtils.isNotBlank((String)(restUrl = RestFulSecurityFilter.this.getRestFulSecurityUrl())) && (sc = (SecutityClient)(mapper = new ObjectMapper()).readValue(HttpTookit.doGet(restUrl = restUrl + "/" + appId, null), SecutityClient.class)) != null) {
                    redisTemplate.opsForValue().set((Object)appId, (Object)sc);
                }
                return new Credential(sc.getClientId(), sc.getClientKey(), sc.getExpiredTs());
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
    }
}

