/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.context.controller;

import com.alibaba.fastjson.JSONObject;
import com.yonyou.iuap.auth.session.SessionManager;
import com.yonyou.iuap.cache.CacheManager;
import com.yyjz.icop.context.UserContext;
import com.yyjz.icop.context.controller.PrivilegeCache;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import redis.clients.jedis.Jedis;

@Controller
public class ContextController {
    private static final String CACHE_PREFIX = "APPLICATION_SM_APP_CACHE:";
    private static String URL_REGX = "[/\\-_\\w]+[/#/]*[/\\?=&\\w[\\u4e00-\\u9fa5\uff08\uff09\\(\\)]]*";
    @Autowired
    private SessionManager sessionManager;
    @Autowired(required=false)
    private CacheManager cacheManager;
    @Autowired
    private PrivilegeCache privilegeCache;

    @RequestMapping(value={"/userContextDemo"})
    @ResponseBody
    public JSONObject getUserContext() {
        JSONObject ans = new JSONObject();
        ans.put("Header", (Object)UserContext.getUserContextByHeader());
        ans.put("InvocationInfoProxy", (Object)UserContext.getUserContextByInvocationInfoProxy());
        return ans;
    }

    @RequestMapping(value={"/getWorkbenchCookie"})
    @ResponseBody
    public String getPortalCookie(@RequestParam(value="callback", required=false) String callback, HttpServletRequest request) throws UnsupportedEncodingException {
        if (StringUtils.isBlank((CharSequence)callback)) {
            return null;
        }
        String regEx = "[`~!@#$%^&*()+=|{}':;',\\[\\]<>/?~\uff01@#\uffe5%]|\n|\r|\t";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(callback);
        if (m.find()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        JSONObject json = new JSONObject();
        String token = this.getValueByCookie(request, "token");
        String userId = this.getValueByCookie(request, "userId");
        if (StringUtils.isNotEmpty((CharSequence)token) && StringUtils.isNotEmpty((CharSequence)userId)) {
            boolean isOnlineSession = this.sessionManager.validateOnlineSession(userId, token);
            if (isOnlineSession) {
                Cookie[] cookies = request.getCookies();
                if (cookies != null && cookies.length > 0) {
                    for (Cookie cookie : cookies) {
                        String name = cookie.getName();
                        if ("icop-context".equals(name) || "icop_context".equals(name) || "JSESSIONID".equals(name) || "NTKF_T2D_CLIENTID".equals(name) || "TGC".equals(name) || "_A_P_defaulstCode".equals(name) || "_A_P_rolename".equals(name) || "_A_P_userAvator".equals(name) || "_A_P_userTheme".equals(name) || "_ga".equals(name) || "enterprise_name".equals(name) || "logo_path".equals(name) || "vertx-web.session".equals(name) || "sensorsdata2015jssdkcross".equals(name) || "tenant_token".equals(name) || "tenant_username".equals(name) || "currentTime".equals(name)) continue;
                        String value = URLDecoder.decode(cookie.getValue(), "utf-8");
                        json.put(name, (Object)value);
                    }
                    boolean validation = this.validateUrl(request, userId);
                    json.put("validation", (Object)(validation + ""));
                }
                sb.append(callback + "(" + json.toJSONString() + ");");
            } else {
                sb.append(callback + "();");
            }
        } else {
            sb.append(callback + "();");
        }
        return sb.toString();
    }

    private String getValueByCookie(HttpServletRequest request, String name) {
        String result = "";
        Cookie[] cookies = request.getCookies();
        if (cookies != null && cookies.length > 0) {
            for (Cookie cookie : cookies) {
                if (!name.equals(cookie.getName())) continue;
                result = cookie.getValue();
            }
        }
        return result;
    }

    private boolean validateUrl(HttpServletRequest request, String userId) throws UnsupportedEncodingException {
        Set<String> cacheValues;
        String userType = this.getValueByCookie(request, "userType");
        if ("1".equals(userType)) {
            return true;
        }
        String roleId = this.getValueByCookie(request, "_A_P_currentRoleId");
        String project_url = this.decodeURL(request);
        if (StringUtils.isNotBlank((CharSequence)project_url) && this.cacheManager != null && (cacheValues = this.getAppInfo(project_url)) != null && !cacheValues.isEmpty()) {
            for (String cacheValue : cacheValues) {
                if (!StringUtils.isNotBlank((CharSequence)cacheValue)) continue;
                String[] splits = cacheValue.split("@@@");
                String pkAppMenu = splits[0];
                String auth = splits[1];
                if ("0".equals(auth)) {
                    return true;
                }
                Set<String> privilegedAppMenuIds = StringUtils.isNotBlank((CharSequence)roleId) ? this.privilegeCache.getPrivilegedAppMenuId(userId, roleId) : this.privilegeCache.getPrivilegedAppMenuId(userId);
                if (!privilegedAppMenuIds.contains(pkAppMenu)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private String decodeURL(HttpServletRequest request) throws UnsupportedEncodingException {
        String project_url = request.getParameter("project_url");
        if (StringUtils.isBlank((CharSequence)project_url)) {
            return null;
        }
        Pattern compile = Pattern.compile(URL_REGX);
        boolean isMatch = false;
        for (int counter = 0; !isMatch || counter > 5; ++counter) {
            Matcher matcher = compile.matcher(project_url);
            isMatch = matcher.matches();
            project_url = URLDecoder.decode(project_url, "UTF-8");
        }
        return project_url;
    }

    private Set<String> getAppInfo(String url) throws UnsupportedEncodingException {
        int indexOf;
        Set<String> cacheValues = this.getCacheValue(URLEncoder.encode(url, "UTF-8"));
        String appURL = url;
        while (appURL.contains("&") && (cacheValues == null || cacheValues.isEmpty())) {
            int index = appURL.lastIndexOf("&");
            appURL = appURL.substring(0, index);
            String key = URLEncoder.encode(appURL, "utf-8");
            cacheValues = this.getCacheValue(key);
        }
        if ((cacheValues == null || cacheValues.isEmpty()) && (indexOf = appURL.indexOf("?")) != -1) {
            appURL = appURL.substring(0, indexOf);
            cacheValues = this.getCacheValue(URLEncoder.encode(appURL, "utf-8"));
        }
        if (cacheValues == null || cacheValues.isEmpty()) {
            appURL = "/" + appURL;
            cacheValues = this.getCacheValue(URLEncoder.encode(appURL, "utf-8"));
        }
        return cacheValues;
    }

    private Set<String> getCacheValue(final String key) {
        Set value = null;
        if (StringUtils.isNotBlank((CharSequence)key)) {
            value = (Set)this.cacheManager.execute((CacheManager.JedisAction)new CacheManager.JedisAction<Set<String>>(){

                public Set<String> action(Jedis jedis) {
                    return jedis.smembers(ContextController.CACHE_PREFIX + key.hashCode());
                }
            });
        }
        return value;
    }
}

