/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.context.controller;

import com.yonyou.iuap.cache.CacheManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springside.modules.nosql.redis.JedisTemplate;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

@Component
public class PrivilegeCache {
    private static final String USER_CACHE_PREFIX = "user_privilege:";
    private static final String APP_CACHE_PREFIX = "app_privilege:";
    private static final String ROLE_SEPARATOR = ":role:";
    private static final String USER_SEPARATOR = ":user:";
    private static final String ORG_SEPARATOR = ":org:";
    @Autowired(required=false)
    private CacheManager cacheManager;

    private List<String> getUserRoleIds(String userId) {
        return this.getUserAppointList(userId, ROLE_SEPARATOR);
    }

    private List<String> getUserDirectOrgIds(String userId) {
        return this.getUserAppointList(userId, ORG_SEPARATOR);
    }

    private List<String> getUserAppointList(String userId, String separator) {
        ArrayList<String> orgIds = new ArrayList<String>();
        String orgPattern = USER_CACHE_PREFIX + userId + separator + "*";
        Set keys = (Set)this.cacheManager.execute(jedis -> jedis.keys(orgPattern));
        for (String key : keys) {
            String orgId = key.split(separator)[1];
            orgIds.add(orgId);
        }
        return orgIds;
    }

    public Set<String> getPrivilegedAppMenuId(final String userId) {
        HashSet<String> appMenuIds = new HashSet<String>();
        final List<String> roleIds = this.getUserRoleIds(userId);
        final List<String> orgIds = this.getUserDirectOrgIds(userId);
        final ArrayList roleKeys = new ArrayList();
        this.cacheManager.piplineExecute(new JedisTemplate.PipelineActionNoResult(){

            public void action(Pipeline pipeline) {
                ArrayList<Response> responses = new ArrayList<Response>();
                for (String roleId : roleIds) {
                    String pattern = "app_privilege:*:role:" + roleId;
                    Response response = pipeline.keys(pattern);
                    responses.add(response);
                }
                pipeline.sync();
                for (Response response : responses) {
                    Set keys = (Set)response.get();
                    roleKeys.addAll(keys);
                }
            }
        });
        for (String key : roleKeys) {
            String appMenuId = key.split(APP_CACHE_PREFIX)[1].split(ROLE_SEPARATOR)[0];
            appMenuIds.add(appMenuId);
        }
        final ArrayList orgKeys = new ArrayList();
        this.cacheManager.piplineExecute(new JedisTemplate.PipelineActionNoResult(){

            public void action(Pipeline pipeline) {
                ArrayList<Response> responses = new ArrayList<Response>();
                for (String s : orgIds) {
                    String pattern = "app_privilege:*:user:" + userId + PrivilegeCache.ORG_SEPARATOR + s;
                    Response response = pipeline.keys(pattern);
                    responses.add(response);
                }
                pipeline.sync();
                for (Response response : responses) {
                    Set keys = (Set)response.get();
                    orgKeys.addAll(keys);
                }
            }
        });
        for (String key : orgKeys) {
            String appMenuId = key.split(APP_CACHE_PREFIX)[1].split(USER_SEPARATOR)[0];
            appMenuIds.add(appMenuId);
        }
        return appMenuIds;
    }

    public Set<String> getPrivilegedAppMenuId(String userId, String roleId) {
        HashSet<String> appMenuIds = new HashSet<String>();
        if (StringUtils.isNotBlank((String)roleId)) {
            String pattern = "app_privilege:*:role:" + roleId;
            Set keys = (Set)this.cacheManager.execute(jedis -> jedis.keys(pattern));
            for (String key : keys) {
                String appMenuId = key.split(APP_CACHE_PREFIX)[1].split(ROLE_SEPARATOR)[0];
                appMenuIds.add(appMenuId);
            }
        }
        return appMenuIds;
    }
}

