/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.context.filter;

import com.alibaba.fastjson.JSONObject;
import com.yonyou.construction.icop.config.utils.IcopConfigUtils;
import com.yonyou.iuap.context.InvocationInfoProxy;
import com.yyjz.icop.base.response.ReturnCode;
import com.yyjz.icop.context.UserContext;
import com.yyjz.icop.context.filter.CustomHttpServletRequest;
import com.yyjz.icop.util.ConfigUtils;
import com.yyjz.icop.util.RestTemplateUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.util.AntPathMatcher;
import org.apache.shiro.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import uap.web.utils.HttpTookit;

public class ContextFilter
implements Filter {
    public static Logger logger = LoggerFactory.getLogger(ContextFilter.class);
    private final String URL_LOGIN_AND_VALIDATE = "rest.api.url.loginAndValidate";
    private final String URL_REST_API_FILTER = "rest.api.url";
    private static RestTemplateUtil restTemplateUtil = new RestTemplateUtil();
    private static RedisTemplate<String, Object> redisTemplate;
    private AntPathMatcher matcher = new AntPathMatcher();
    private String[] excludeUrls = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] formatParam(String param) {
        ArrayList<String> urls = new ArrayList<String>();
        try (Scanner scanner = new Scanner(param);){
            while (scanner.hasNextLine()) {
                String rawLine = scanner.nextLine();
                String line = StringUtils.clean((String)rawLine);
                if (line == null) continue;
                urls.add(line);
            }
        }
        return urls.toArray(new String[urls.size()]);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            String excludeConfig = filterConfig.getInitParameter("excludeConfig");
            if (excludeConfig != null) {
                this.excludeUrls = ContextFilter.formatParam(excludeConfig);
            }
            ServletContext context = filterConfig.getServletContext();
            WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
            redisTemplate = (RedisTemplate)ctx.getBean("redisTemplate", RedisTemplate.class);
        }
        catch (Exception e) {
            logger.info("\u521d\u59cb\u5316 redisTemplate \u5f02\u5e38!");
            e.printStackTrace();
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        CustomHttpServletRequest customRequest = new CustomHttpServletRequest(request);
        boolean isExclude = false;
        if (this.excludeUrls != null && this.excludeUrls.length > 0) {
            for (String pattern : this.excludeUrls) {
                if (!this.matcher.matchStart(customRequest.getServletPath(), pattern)) continue;
                isExclude = true;
                break;
            }
        }
        if (!isExclude) {
            Map<String, String> restResult = this.restLoginAndValidate(customRequest);
            if ("inner_rest".equals(restResult.get("code"))) {
                block17: {
                    try {
                        String token = this.getToken(request);
                        if (token != null) {
                            if (redisTemplate.opsForValue().get((Object)token) == null) {
                                String userId = this.getUserId(request);
                                if (userId != null) {
                                    String contextUrl = this.getPropertyByKey("icop.usercenter.web.serverName") + "usercenter/context";
                                    HashMap<String, String> params = new HashMap<String, String>();
                                    params.put("userId", userId);
                                    String userContextStr = restTemplateUtil.get((ServletRequest)customRequest, contextUrl, params);
                                    try {
                                        JSONObject userContext = JSONObject.parseObject((String)userContextStr);
                                        JSONObject init = userContext.getJSONObject("init");
                                        if (init.getString("code").equals(ReturnCode.FAILURE.getValue())) {
                                            throw new Exception(init.getString("tip"));
                                        }
                                        if (init.containsKey((Object)"tip")) {
                                            logger.error(init.getString("tip"));
                                        }
                                        break block17;
                                    }
                                    catch (Exception e) {
                                        logger.error(e.getMessage().equals(ReturnCode.REGEX_CHINESE.getValue()) ? e.getMessage() : ">>>>>>>\u8c03\u7528\u521d\u59cb\u5316\u4e0a\u4e0b\u6587\u670d\u52a1\u5f02\u5e38, url=> " + contextUrl);
                                    }
                                    break block17;
                                }
                                logger.error("\u5f53\u524d\u4e0a\u4e0b\u6587\u4e2d\u65e0\u6cd5\u83b7\u53d6\u5230userid");
                                break block17;
                            }
                            redisTemplate.expire((Object)token, (long)UserContext.USER_CONTEXT_EXPIRETIME.intValue(), TimeUnit.SECONDS);
                            break block17;
                        }
                        logger.error("\u5f53\u524d\u4e0a\u4e0b\u6587\u65e0\u6cd5\u83b7\u53d6\u5230Token");
                    }
                    catch (Exception e) {
                        StringWriter sw = new StringWriter();
                        e.printStackTrace(new PrintWriter(sw));
                        logger.error(e.getMessage().matches(ReturnCode.REGEX_CHINESE.getValue()) ? e.getMessage() : "\u521d\u59cb\u5316\u4e0a\u4e0b\u6587\u5f02\u5e38>>>\n" + sw.toString());
                    }
                }
                chain.doFilter((ServletRequest)customRequest, res);
            } else if ("failed".equals(restResult.get("code"))) {
                logger.error(restResult.get("message"));
                req.setAttribute("errorMsg", (Object)"\u767b\u5f55\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u60a8\u8f93\u5165\u7684\u7528\u6237\u540d\u6216\u5bc6\u7801\u662f\u5426\u6b63\u786e\uff01");
                chain.doFilter((ServletRequest)customRequest, res);
            } else if ("success".equals(restResult.get("code"))) {
                chain.doFilter((ServletRequest)customRequest, res);
            }
        }
    }

    public void destroy() {
    }

    private Map<String, String> restLoginAndValidate(CustomHttpServletRequest customRequest) throws ServletException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            String[] restUrls;
            String userHeader = customRequest.getParameter("icop-user");
            userHeader = org.apache.commons.lang.StringUtils.isBlank((String)userHeader) ? customRequest.getHeader("icop-user") : userHeader;
            boolean isRestLogin = false;
            String restApi = this.getPropertyByKey("rest.api.url");
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)restApi) && (restUrls = restApi.split(",")) != null && restUrls.length > 0) {
                for (String pattern : restUrls) {
                    if (!this.matcher.matchStart(customRequest.getServletPath(), pattern)) continue;
                    isRestLogin = true;
                    break;
                }
            }
            if (isRestLogin) {
                if (org.apache.commons.lang.StringUtils.isBlank((String)userHeader)) {
                    logger.error("icop-user\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6b63\u786e\u4f20\u5165");
                    resultMap.put("code", "failed");
                    resultMap.put("message", "icop-user\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6b63\u786e\u4f20\u5165");
                    return resultMap;
                }
                String url = this.getPropertyByKey("rest.api.url.loginAndValidate");
                if (org.apache.commons.lang.StringUtils.isBlank((String)url)) {
                    logger.error("\u6a21\u62df\u767b\u9646\u5931\u8d25,\u8bf7\u68c0\u67e5property\u6587\u4ef6\u662f\u5426\u6b63\u786e\u914d\u7f6e\u767b\u5f55\u8bf7\u6c42\u8def\u5f84:key:rest.api.url.loginAndValidate");
                    resultMap.put("code", "failed");
                    resultMap.put("message", "\u6a21\u62df\u767b\u9646\u5931\u8d25,\u8bf7\u68c0\u67e5property\u6587\u4ef6\u662f\u5426\u6b63\u786e\u914d\u7f6e\u767b\u5f55\u8bf7\u6c42\u8def\u5f84:key:rest.api.url.loginAndValidate");
                    return resultMap;
                }
                HashMap<String, String> headers = new HashMap<String, String>();
                JSONObject params = new JSONObject();
                JSONObject userObj = JSONObject.parseObject((String)userHeader);
                for (Map.Entry next : userObj.entrySet()) {
                    String key = (String)next.getKey();
                    String value = (String)next.getValue();
                    params.put(key, (Object)value);
                }
                if (!params.containsKey((Object)"systemId")) {
                    params.put("systemId", (Object)"icop");
                }
                String token = (String)redisTemplate.opsForHash().get((Object)(params.get((Object)"userName") + "_SSO"), (Object)"token");
                String restResult = null;
                if (org.apache.commons.lang.StringUtils.isNotEmpty((String)token)) {
                    String userId = (String)redisTemplate.opsForHash().get((Object)(params.get((Object)"userName") + "_SSO"), (Object)"userId");
                    String tenantId = (String)redisTemplate.opsForHash().get((Object)(params.get((Object)"userName") + "_SSO"), (Object)"tenantId");
                    String authority = (String)redisTemplate.opsForHash().get((Object)(params.get((Object)"userName") + "_SSO"), (Object)"authority");
                    JSONObject redisUserContext = (JSONObject)redisTemplate.opsForValue().get((Object)token);
                    if (redisUserContext == null) {
                        redisTemplate.opsForHash().delete((Object)(params.get((Object)"userName") + "_SSO"), new Object[]{"token"});
                        redisTemplate.opsForHash().delete((Object)(params.get((Object)"userName") + "_SSO"), new Object[]{"userId"});
                        redisTemplate.opsForHash().delete((Object)(params.get((Object)"userName") + "_SSO"), new Object[]{"tenantId"});
                        redisTemplate.opsForHash().delete((Object)(params.get((Object)"userName") + "_SSO"), new Object[]{"authority"});
                        restResult = HttpTookit.doPostWithJson(url, params.toJSONString(), headers);
                        JSONObject userContext = JSONObject.parseObject((String)restResult);
                        JSONObject userValidate = userContext.getJSONObject("userValidate");
                        if (!"0".equals(userValidate.getString("status"))) {
                            JSONObject userAuthority = userContext.getJSONObject("authority");
                            String authentication = userContext.getString("authentication");
                            token = userAuthority.getString("token");
                            tenantId = userAuthority.getString("tenantid");
                            redisTemplate.opsForHash().put((Object)(params.get((Object)"userName") + "_SSO"), (Object)"token", (Object)token);
                            redisTemplate.opsForHash().put((Object)(params.get((Object)"userName") + "_SSO"), (Object)"userId", (Object)userAuthority.getString("userId"));
                            redisTemplate.opsForHash().put((Object)(params.get((Object)"userName") + "_SSO"), (Object)"tenantId", (Object)tenantId);
                            redisTemplate.opsForHash().put((Object)(params.get((Object)"userName") + "_SSO"), (Object)"authority", (Object)authentication);
                            redisTemplate.expire((Object)(params.get((Object)"userName") + "_SSO"), (long)UserContext.USER_CONTEXT_EXPIRETIME.intValue(), TimeUnit.SECONDS);
                            InvocationInfoProxy.setUserid((String)userAuthority.getString("userId"));
                            InvocationInfoProxy.setToken((String)token);
                            InvocationInfoProxy.setTenantid((String)tenantId);
                            InvocationInfoProxy.setParameter((String)"authority", (String)authentication);
                            customRequest.putHeader("authority", authentication);
                            resultMap.put("code", "success");
                        } else {
                            InvocationInfoProxy.reset();
                            resultMap.put("code", "failed");
                            resultMap.put("message", "\u767b\u5f55\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u60a8\u8f93\u5165\u7684\u7528\u6237\u540d\u6216\u5bc6\u7801\u662f\u5426\u6b63\u786e");
                        }
                    } else {
                        InvocationInfoProxy.setUserid((String)userId);
                        InvocationInfoProxy.setToken((String)token);
                        InvocationInfoProxy.setTenantid((String)tenantId);
                        InvocationInfoProxy.setParameter((String)"authority", (String)authority);
                        customRequest.putHeader("authority", authority);
                    }
                    resultMap.put("code", "success");
                } else {
                    restResult = HttpTookit.doPostWithJson(url, params.toJSONString(), headers);
                    JSONObject userContext = JSONObject.parseObject((String)restResult);
                    JSONObject userValidate = userContext.getJSONObject("userValidate");
                    if (!"0".equals(userValidate.getString("status"))) {
                        JSONObject userAuthority = userContext.getJSONObject("authority");
                        String authentication = userContext.getString("authentication");
                        token = userAuthority.getString("token");
                        String tenantId = userAuthority.getString("tenantid");
                        redisTemplate.opsForHash().put((Object)(params.get((Object)"userName") + "_SSO"), (Object)"token", (Object)token);
                        redisTemplate.opsForHash().put((Object)(params.get((Object)"userName") + "_SSO"), (Object)"userId", (Object)userAuthority.getString("userId"));
                        redisTemplate.opsForHash().put((Object)(params.get((Object)"userName") + "_SSO"), (Object)"tenantId", (Object)tenantId);
                        redisTemplate.opsForHash().put((Object)(params.get((Object)"userName") + "_SSO"), (Object)"authority", (Object)authentication);
                        redisTemplate.expire((Object)(params.get((Object)"userName") + "_SSO"), (long)UserContext.USER_CONTEXT_EXPIRETIME.intValue(), TimeUnit.SECONDS);
                        InvocationInfoProxy.setUserid((String)userAuthority.getString("userId"));
                        InvocationInfoProxy.setToken((String)token);
                        InvocationInfoProxy.setTenantid((String)tenantId);
                        InvocationInfoProxy.setParameter((String)"authority", (String)authentication);
                        customRequest.putHeader("authority", authentication);
                        resultMap.put("code", "success");
                    } else {
                        InvocationInfoProxy.reset();
                        resultMap.put("code", "failed");
                        resultMap.put("message", "\u767b\u5f55\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u60a8\u8f93\u5165\u7684\u7528\u6237\u540d\u6216\u5bc6\u7801\u662f\u5426\u6b63\u786e");
                    }
                }
            } else {
                resultMap.put("code", "inner_rest");
            }
        }
        catch (Exception e) {
            resultMap.put("code", "failed");
            resultMap.put("message", "rest\u6a21\u62df\u767b\u9646\u5f02\u5e38>>>:" + e.getMessage());
            logger.error("rest\u6a21\u62df\u767b\u9646\u5f02\u5e38>>>:" + e.getMessage());
        }
        return resultMap;
    }

    public String getPropertyByKey(String propKey) {
        String result = null;
        try {
            Properties properties = IcopConfigUtils.getFromServer();
            result = properties.getProperty(propKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (org.apache.commons.lang.StringUtils.isBlank(result)) {
            result = ConfigUtils.getPropertyByKey(propKey);
        }
        return result;
    }

    public String getToken(HttpServletRequest request) {
        Cookie[] cookies;
        String token = InvocationInfoProxy.getToken();
        if (org.apache.commons.lang.StringUtils.isBlank((String)token) && (cookies = request.getCookies()) != null && cookies.length > 0) {
            for (Cookie cookie : cookies) {
                if (!"token".equals(cookie.getName())) continue;
                token = cookie.getValue();
                break;
            }
        }
        return token;
    }

    public String getUserId(HttpServletRequest request) {
        Cookie[] cookies;
        String userId = InvocationInfoProxy.getUserid();
        if (org.apache.commons.lang.StringUtils.isBlank((String)userId) && (cookies = request.getCookies()) != null && cookies.length > 0) {
            for (Cookie cookie : cookies) {
                if (!"userId".equals(cookie.getName())) continue;
                userId = cookie.getValue();
                break;
            }
        }
        return userId;
    }
}

