/*
 * Decompiled with CFR 0.152.
 */
package uap.web.utils;

import com.yonyou.iuap.security.rest.common.Credential;
import com.yonyou.iuap.security.rest.exception.UAPSecurityException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCredentialGenerator {
    private static final Logger logger = LoggerFactory.getLogger(ClientCredentialGenerator.class);
    private static Map<String, Properties> propertiesMap = new HashMap<String, Properties>();

    public static Credential loadCredential(String path) throws UAPSecurityException {
        try {
            if (!propertiesMap.containsKey(path)) {
                ClientCredentialGenerator.loadFiles(path);
            }
            Properties properties = propertiesMap.get(path);
            return new Credential(properties.getProperty("appId"), properties.getProperty("key"), properties.getProperty("expiredTs"));
        }
        catch (IOException e) {
            logger.error("\u5ba2\u6237\u7aef\u8bc1\u4e66\u8def\u5f84" + path + "\u4e0d\u6b63\u786e!", (Throwable)e);
            throw new UAPSecurityException("\u5ba2\u6237\u7aef\u8bc1\u4e66\u8def\u5f84" + path + "\u4e0d\u6b63\u786e!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadFiles(String path) throws IOException {
        if (propertiesMap.containsKey(path)) return;
        Class<ClientCredentialGenerator> clazz = ClientCredentialGenerator.class;
        synchronized (ClientCredentialGenerator.class) {
            if (propertiesMap.containsKey(path)) return;
            try (FileInputStream in = null;){
                in = new FileInputStream(path);
                Properties properties = new Properties();
                properties.load(in);
                propertiesMap.put(path, properties);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

