/*
 * Decompiled with CFR 0.152.
 */
package uap.web.utils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import uap.web.utils.AnyTrustStrategy;

public class HttpTookit {
    public static final String DEFAULT_AGENT = "iuap.client";
    private static CloseableHttpClient client;
    public static String defaultEncoding;

    public static boolean initParms() {
        return true;
    }

    public static String doGet(String url, Map<String, String> params) {
        return HttpTookit.doGet(url, params, null, "UTF-8");
    }

    public static String doPost(String url, Map<String, String> params) {
        return HttpTookit.doPost(url, params, null, "UTF-8");
    }

    public static String doDelete(String url, Map<String, String> params) {
        return HttpTookit.doDelete(url, params, null, "UTF-8");
    }

    public static String doPut(String url, Map<String, String> params) {
        return HttpTookit.doPut(url, params, null, "UTF-8");
    }

    public static String doGet(String url, Map<String, String> params, Map<String, String> headers) {
        return HttpTookit.doGet(url, params, headers, "UTF-8");
    }

    public static String doPost(String url, Map<String, String> params, Map<String, String> headers) {
        return HttpTookit.doPost(url, params, headers, "UTF-8");
    }

    public static String doDelete(String url, Map<String, String> params, Map<String, String> headers) {
        return HttpTookit.doDelete(url, params, headers, "UTF-8");
    }

    public static String doPostWithJson(String url, String json, Map<String, String> headers) {
        return HttpTookit.doPostWithJson(url, json, headers, "UTF-8");
    }

    public static String doPut(String url, Map<String, String> params, Map<String, String> headers) {
        return HttpTookit.doPut(url, params, headers, "UTF-8");
    }

    public static String doPostFile(String url, Map<String, String> params, Map<String, String> headers, String filepath) {
        return HttpTookit.doPostFile(url, params, headers, filepath, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url, Map<String, String> params, Map<String, String> headers, String charset) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        CloseableHttpResponse response = null;
        HttpGet httpGet = null;
        try {
            if (params != null && !params.isEmpty()) {
                ArrayList pairs = new ArrayList(params.size());
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String value = entry.getValue();
                    if (value == null) continue;
                    pairs.add(new BasicNameValuePair(entry.getKey(), value));
                }
                url = url + "?" + EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity((List)pairs, charset));
            }
            httpGet = new HttpGet(url);
            if (headers != null && !headers.isEmpty()) {
                for (Map.Entry entry : headers.entrySet()) {
                    httpGet.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(360000).setConnectTimeout(360000).build();
            httpGet.setConfig(requestConfig);
            response = client.execute((HttpUriRequest)httpGet);
            int n = response.getStatusLine().getStatusCode();
            if (n != 200) {
                httpGet.abort();
                throw new RuntimeException("client,error status code :" + n);
            }
            HttpEntity entity = response.getEntity();
            String result = null;
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            }
            EntityUtils.consume((HttpEntity)entity);
            String string = result;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (httpGet != null) {
                httpGet.releaseConnection();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, Map<String, String> params, Map<String, String> headers, String charset) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        HttpPost httpPost = null;
        CloseableHttpResponse response = null;
        try {
            int statusCode;
            ArrayList<BasicNameValuePair> pairs = null;
            if (params != null && !params.isEmpty()) {
                pairs = new ArrayList<BasicNameValuePair>(params.size());
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String value = entry.getValue();
                    if (value == null) continue;
                    pairs.add(new BasicNameValuePair(entry.getKey(), value));
                }
            }
            httpPost = new HttpPost(url);
            if (pairs != null && pairs.size() > 0) {
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, "UTF-8"));
            }
            if (headers != null && !headers.isEmpty()) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpPost.addHeader(entry.getKey(), entry.getValue());
                }
            }
            if ((statusCode = (response = client.execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode()) != 200) {
                httpPost.abort();
                throw new RuntimeException("client,error status code :" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            String result = null;
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            }
            EntityUtils.consume((HttpEntity)entity);
            String string = result;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostFile(String url, Map<String, String> params, Map<String, String> headers, String filepath, String charset) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        HttpPost httpPost = null;
        CloseableHttpResponse response = null;
        try {
            int statusCode;
            FileBody bin = new FileBody(new File(filepath));
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addPart("file", (ContentBody)bin);
            httpPost = new HttpPost(url);
            httpPost.setEntity(builder.build());
            if (headers != null && !headers.isEmpty()) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpPost.addHeader(entry.getKey(), entry.getValue());
                }
            }
            if ((statusCode = (response = client.execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode()) != 200) {
                httpPost.abort();
                throw new RuntimeException("client,error status code :" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            String result = null;
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            }
            EntityUtils.consume((HttpEntity)entity);
            String string = result;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostWithJson(String url, String json, Map<String, String> headers, String charset) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        HttpPost httpPost = null;
        CloseableHttpResponse response = null;
        try {
            httpPost = new HttpPost(url);
            if (headers != null && !headers.isEmpty()) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpPost.addHeader(entry.getKey(), entry.getValue());
                }
            }
            StringEntity s = new StringEntity(json, "UTF-8");
            s.setContentEncoding("UTF-8");
            s.setContentType("application/json");
            httpPost.setEntity((HttpEntity)s);
            response = client.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                httpPost.abort();
                throw new RuntimeException("client,error status code :" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            String result = null;
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            }
            EntityUtils.consume((HttpEntity)entity);
            String string = result;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doDelete(String url, Map<String, String> params, Map<String, String> headers, String charset) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        CloseableHttpResponse response = null;
        HttpDelete httpDelete = null;
        try {
            if (params != null && !params.isEmpty()) {
                ArrayList pairs = new ArrayList(params.size());
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String value = entry.getValue();
                    if (value == null) continue;
                    pairs.add(new BasicNameValuePair(entry.getKey(), value));
                }
                url = url + "?" + EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity((List)pairs, charset));
            }
            httpDelete = new HttpDelete(url);
            if (headers != null && !headers.isEmpty()) {
                for (Map.Entry entry : headers.entrySet()) {
                    httpDelete.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(360000).setConnectTimeout(360000).build();
            httpDelete.setConfig(requestConfig);
            response = client.execute((HttpUriRequest)httpDelete);
            int n = response.getStatusLine().getStatusCode();
            if (n != 200) {
                httpDelete.abort();
                throw new RuntimeException("client,error status code :" + n);
            }
            HttpEntity entity = response.getEntity();
            String result = null;
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            }
            EntityUtils.consume((HttpEntity)entity);
            String string = result;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (httpDelete != null) {
                httpDelete.releaseConnection();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPut(String url, Map<String, String> params, Map<String, String> headers, String charset) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        CloseableHttpResponse response = null;
        HttpPut httpPut = null;
        try {
            int statusCode;
            ArrayList<BasicNameValuePair> pairs = null;
            if (params != null && !params.isEmpty()) {
                pairs = new ArrayList<BasicNameValuePair>(params.size());
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String value = entry.getValue();
                    if (value == null) continue;
                    pairs.add(new BasicNameValuePair(entry.getKey(), value));
                }
            }
            httpPut = new HttpPut(url);
            if (pairs != null && pairs.size() > 0) {
                httpPut.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, "UTF-8"));
            }
            if (headers != null && !headers.isEmpty()) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpPut.addHeader(entry.getKey(), entry.getValue());
                }
            }
            if ((statusCode = (response = client.execute((HttpUriRequest)httpPut)).getStatusLine().getStatusCode()) != 200) {
                httpPut.abort();
                throw new RuntimeException("client,error status code :" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            String result = null;
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            }
            EntityUtils.consume((HttpEntity)entity);
            String string = result;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (httpPut != null) {
                httpPut.releaseConnection();
            }
        }
        return null;
    }

    static {
        defaultEncoding = "utf-8";
        ConnectionConfig connConfig = ConnectionConfig.custom().setCharset(Charset.forName(defaultEncoding)).build();
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(10000).build();
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        PlainConnectionSocketFactory plainSF = new PlainConnectionSocketFactory();
        registryBuilder.register("http", (Object)plainSF);
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            SSLContext sslContext = SSLContexts.custom().useTLS().loadTrustMaterial(trustStore, (TrustStrategy)new AnyTrustStrategy()).build();
            SSLConnectionSocketFactory sslSF = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            registryBuilder.register("https", (Object)sslSF);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        Registry registry = registryBuilder.build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(registry);
        connManager.setDefaultConnectionConfig(connConfig);
        connManager.setDefaultSocketConfig(socketConfig);
        connManager.setDefaultMaxPerRoute(200);
        connManager.setMaxTotal(200);
        client = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connManager).setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(2000).setConnectTimeout(3000).setSocketTimeout(5000).build()).setUserAgent(DEFAULT_AGENT).build();
    }
}

