/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.context.controller;

import com.alibaba.fastjson.JSONObject;
import com.yonyou.iuap.auth.session.SessionManager;
import com.yyjz.icop.context.UserContext;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ContextController {
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/userContextDemo"})
    @ResponseBody
    public JSONObject getUserContext() {
        JSONObject ans = new JSONObject();
        ans.put("Header", (Object)UserContext.getUserContextByHeader());
        ans.put("InvocationInfoProxy", (Object)UserContext.getUserContextByInvocationInfoProxy());
        return ans;
    }

    public static void main(String[] args) {
        String regEx = "[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]|\n|\r|\t";
        String str = "jQuery111205591952721683318_1508291059645";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        if (m.find()) {
            System.out.println(1);
        } else {
            System.out.println(2);
        }
    }

    @RequestMapping(value={"/getWorkbenchCookie"})
    @ResponseBody
    public String getPortalCookie(@RequestParam(value="callback") String callback, HttpServletRequest request) throws UnsupportedEncodingException {
        String regEx = "[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]|\n|\r|\t";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(callback);
        if (m.find()) {
            callback = "jQuery111205591952721683318_1508291059645";
        }
        StringBuffer sb = new StringBuffer();
        JSONObject json = new JSONObject();
        String token = this.getValueByCookie(request, "token");
        String userId = this.getValueByCookie(request, "userId");
        if (StringUtils.isNotEmpty((CharSequence)token) && StringUtils.isNotEmpty((CharSequence)userId)) {
            boolean isOnlineSession = this.sessionManager.validateOnlineSession(userId, token);
            if (isOnlineSession) {
                Cookie[] cookies = request.getCookies();
                if (cookies != null && cookies.length > 0) {
                    for (Cookie cookie : cookies) {
                        String name = cookie.getName();
                        if ("icop-context".equals(name) || "icop_context".equals(name) || "_A_P_rolename".equals(name)) continue;
                        String value = URLDecoder.decode(cookie.getValue(), "utf-8");
                        json.put(name, (Object)value);
                    }
                }
                sb.append(callback + "(" + json.toJSONString() + ");");
            } else {
                sb.append(callback + "();");
            }
        } else {
            sb.append(callback + "();");
        }
        return sb.toString();
    }

    private String getValueByCookie(HttpServletRequest request, String name) {
        String result = "";
        Cookie[] cookies = request.getCookies();
        if (cookies != null && cookies.length > 0) {
            for (Cookie cookie : cookies) {
                if (!name.equals(cookie.getName())) continue;
                result = cookie.getValue();
            }
        }
        return result;
    }
}

