/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.context.filter;

import com.alibaba.fastjson.JSONObject;
import com.yonyou.construction.icop.config.utils.IcopConfigUtils;
import com.yonyou.iuap.context.InvocationInfoProxy;
import com.yyjz.icop.base.response.ReturnCode;
import com.yyjz.icop.context.UserContext;
import com.yyjz.icop.util.ConfigUtils;
import com.yyjz.icop.util.RestTemplateUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.util.AntPathMatcher;
import org.apache.shiro.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ContextFilter
implements Filter {
    public static Logger logger = LoggerFactory.getLogger(ContextFilter.class);
    private static RestTemplateUtil restTemplateUtil = new RestTemplateUtil();
    private static RedisTemplate<String, Object> redisTemplate;
    private AntPathMatcher matcher = new AntPathMatcher();
    private String[] excludeUrls = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] formatParam(String param) {
        ArrayList<String> urls = new ArrayList<String>();
        try (Scanner scanner = new Scanner(param);){
            while (scanner.hasNextLine()) {
                String rawLine = scanner.nextLine();
                String line = StringUtils.clean((String)rawLine);
                if (line == null) continue;
                urls.add(line);
            }
        }
        return urls.toArray(new String[urls.size()]);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            String excludeConfig = filterConfig.getInitParameter("excludeConfig");
            if (excludeConfig != null) {
                this.excludeUrls = ContextFilter.formatParam(excludeConfig);
            }
            ServletContext context = filterConfig.getServletContext();
            WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
            redisTemplate = (RedisTemplate)ctx.getBean("redisTemplate", RedisTemplate.class);
        }
        catch (Exception e) {
            logger.info("\u521d\u59cb\u5316 redisTemplate \u5f02\u5e38!");
            e.printStackTrace();
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        block12: {
            HttpServletRequest request = (HttpServletRequest)req;
            boolean isExclude = false;
            if (this.excludeUrls != null && this.excludeUrls.length > 0) {
                for (String pattern : this.excludeUrls) {
                    if (!this.matcher.match(pattern, request.getServletPath())) continue;
                    isExclude = true;
                    break;
                }
            }
            if (!isExclude) {
                try {
                    if (InvocationInfoProxy.getToken() != null) {
                        if (redisTemplate.opsForValue().get((Object)InvocationInfoProxy.getToken()) == null) {
                            if (InvocationInfoProxy.getUserid() != null) {
                                String contextUrl = this.getUserProperties() + "usercenter/context";
                                HashMap<String, String> params = new HashMap<String, String>();
                                params.put("userId", InvocationInfoProxy.getUserid());
                                String userContextStr = restTemplateUtil.get((ServletRequest)request, contextUrl, params);
                                try {
                                    JSONObject userContext = JSONObject.parseObject((String)userContextStr);
                                    JSONObject init = userContext.getJSONObject("init");
                                    if (init.getString("code").equals(ReturnCode.FAILURE.getValue())) {
                                        throw new Exception(init.getString("tip"));
                                    }
                                    if (init.containsKey((Object)"tip")) {
                                        logger.error(init.getString("tip"));
                                    }
                                    break block12;
                                }
                                catch (Exception e) {
                                    throw new Exception(e.getMessage().equals(ReturnCode.REGEX_CHINESE.getValue()) ? e.getMessage() : ">>>>>>>\u8c03\u7528\u521d\u59cb\u5316\u4e0a\u4e0b\u6587\u670d\u52a1\u5f02\u5e38, url=> " + contextUrl);
                                }
                            }
                            throw new Exception("InvocationInfoProxy \u65e0\u6cd5\u83b7\u53d6\u5230userid");
                        }
                        redisTemplate.expire((Object)InvocationInfoProxy.getToken(), (long)UserContext.USER_CONTEXT_EXPIRETIME.intValue(), TimeUnit.SECONDS);
                        break block12;
                    }
                    throw new Exception("InvocationInfoProxy \u65e0\u6cd5\u83b7\u53d6\u5230Token");
                }
                catch (Exception e) {
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    logger.error(e.getMessage().matches(ReturnCode.REGEX_CHINESE.getValue()) ? e.getMessage() : "\u521d\u59cb\u5316\u4e0a\u4e0b\u6587\u5f02\u5e38>>>\n" + sw.toString());
                }
            }
        }
        chain.doFilter(req, res);
    }

    public void destroy() {
    }

    public String getUserProperties() {
        String result = null;
        try {
            Properties properties = IcopConfigUtils.getFromServer();
            result = properties.getProperty("icop.usercenter.web.serverName");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (org.apache.commons.lang.StringUtils.isBlank(result)) {
            result = ConfigUtils.getPropertyByKey("icop.usercenter.web.serverName");
        }
        return result;
    }
}

