package com.yonyou.message.center.auth;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;

import com.yonyou.iuap.auth.shiro.StatelessAuthcFilter;
import com.yonyou.iuap.context.InvocationInfoProxy;
import com.yonyou.iuap.utils.PropertyUtil;

public class InternalAuthcFilter extends StatelessAuthcFilter {

	private String internalToken = PropertyUtil.getPropertyByKey("internalToken");

	public boolean include(HttpServletRequest request) {
		if (super.include(request)) {
			return true;
		}
		String token = request.getHeader("token");
		String tenant = request.getHeader("tenant");
		if (StringUtils.isBlank(token)) {
			token = request.getParameter("token");
		}
		if (StringUtils.isBlank(tenant)) {
			tenant = request.getParameter("tenant");
		}
		if ((StringUtils.isBlank(token)) || (StringUtils.isBlank(tenant))) {
			return false;
		}
		if (!this.internalToken.equals(token))
			return false;
		InvocationInfoProxy.setTenantid(tenant);
		return true;
	}
}