package com.yonyou.message.center.controller;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yonyou.iuap.generic.adapter.InvocationInfoProxyAdapter;
import com.yonyou.message.center.service.MessageSendSdk;
import com.yonyou.uap.msg.template.service.IMsgTemplateCreate;
import com.yonyou.uap.msg.template.service.impl.MsgTemplateDefaultBusiVarImpl;

import net.sf.json.JSONObject;

@SuppressWarnings("unchecked")
@RestController
@RequestMapping({ "/message/" })
public class MessagePush {
	private static final Logger logger = LoggerFactory.getLogger(MessagePush.class);

	@Autowired
	private IMsgTemplateCreate msgTemplateCreate;

	@Autowired
	private MessageSendSdk messageSendSdk;

	@RequestMapping({ "/getMessageByTemplate" })
	@ResponseBody
	public Object getMessageByTemplate(String data) {
		Map<String,Object> dataMap = null;
		try {
			dataMap = (Map<String,Object>) new ObjectMapper().readValue(data, HashMap.class);
		} catch (IOException e) {
			
			logger.error("JSON转换成Map时出错，jsonString : " + data, e);
			Map<String,Object> returnMap = new HashMap<String,Object>();
			returnMap.put("msg", "传入的参数格式有误，不是一个标准的JSON字符串。Parameter : " + data);
			returnMap.put("status", Integer.valueOf(0));
			return returnMap;
		}
		String templateCode = (String) dataMap.get("templateCode");
		if (StringUtils.isEmpty(templateCode)) {
			Map<String,Object> returnMap = new HashMap<String,Object>();
			returnMap.put("msg", "无模板编码参数。Parameter : " + data);
			returnMap.put("status", Integer.valueOf(0));
			return returnMap;
		}
		Map<String,Object> busiDataMap = (Map<String,Object>) dataMap.get("busiData");
		try {
			return this.msgTemplateCreate.createMessageByCode(templateCode,
					new MsgTemplateDefaultBusiVarImpl(busiDataMap));
		} catch (Exception e) {
			logger.error("创建消息失败", e);
			Map<String,Object> returnMap = new HashMap<String,Object>();
			returnMap.put("msg", "创建消息失败。busiData : " + dataMap.get("busiData"));
			returnMap.put("status", Integer.valueOf(0));
			return returnMap;
		}
	}

	@RequestMapping(method = { org.springframework.web.bind.annotation.RequestMethod.POST }, value = {"/pushTemplateMessage" })
	@ResponseBody
	public Object pushTemplateMessage(HttpServletRequest request, HttpServletResponse response,@RequestBody String json) {
		Map<String,Object> returnMap = new HashMap<String,Object>();
		String jsonString = request.getParameter("data");
		if (StringUtils.isBlank(jsonString)) {
			jsonString = JSONObject.fromObject(json).getString("data");
		}

		String tenantid = InvocationInfoProxyAdapter.getTenantid();
		if (StringUtils.isBlank(tenantid)) {
			try {
				Map<String,Object> dataMap = (Map<String,Object>) new ObjectMapper().readValue(jsonString, HashMap.class);
				String pushTenantid = dataMap.get("tenantid").toString();
				if (StringUtils.isBlank(pushTenantid)) {
					returnMap.put("msg", "租户是必传字段");
					returnMap.put("status", Integer.valueOf(0));
					return returnMap;
				}
				InvocationInfoProxyAdapter.setTenantid(pushTenantid);
			} catch (Exception e) {
				logger.error(e.getMessage(), e);
			}
		}
		returnMap = this.messageSendSdk.pushTemplateMessage(jsonString);
		return returnMap;
	}

	@RequestMapping(method = { org.springframework.web.bind.annotation.RequestMethod.POST }, value = { "/pushTextMessage" })
	@ResponseBody
	public Object pushTextMessage(HttpServletRequest request, HttpServletResponse response, @RequestBody String json) {
		Map<String, Object> returnMap = new HashMap<String, Object>();
		String jsonString = request.getParameter("data");
		System.out.println(jsonString);
		if (StringUtils.isBlank(jsonString)) {
			jsonString = JSONObject.fromObject(json).getString("data");
		}

		String tenantid = InvocationInfoProxyAdapter.getTenantid();
		if (StringUtils.isBlank(tenantid)) {
			try {
				Map<String,Object> dataMap = (Map<String,Object>) new ObjectMapper().readValue(jsonString, HashMap.class);
				String pushTenantid = dataMap.get("tenantid").toString();
				if (StringUtils.isBlank(pushTenantid)) {
					returnMap.put("msg", "租户是必传字段");
					returnMap.put("status", Integer.valueOf(0));
					return returnMap;
				}
				InvocationInfoProxyAdapter.setTenantid(pushTenantid);
			} catch (Exception e) {
				logger.error(e.getMessage(), e);
			}
		}
		returnMap = this.messageSendSdk.pushTextMessage(jsonString);
		return returnMap;
	}
}