package com.yonyou.message.center.filter;

import java.net.MalformedURLException;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.yonyou.iuap.security.rest.api.Verifier;
import com.yonyou.iuap.security.rest.common.Credential;
import com.yonyou.iuap.security.rest.common.SignProp;
import com.yonyou.iuap.security.rest.exception.UAPSecurityException;
import com.yonyou.iuap.security.rest.factory.ServerVerifyFactory;
import com.yonyou.iuap.security.rest.rsa.server.RSAServerVerfier;
import com.yonyou.iuap.security.rest.utils.ClientCredentialGenerator;
import com.yonyou.iuap.security.rest.utils.PostParamsHelper;
import com.yonyou.iuap.security.rest.utils.SignPropGenerator;
import com.yonyou.iuap.utils.PropertyUtil;
import com.yonyou.message.center.sign.MsgDigestVerifier;
import com.yonyou.uap.msg.utils.MsgPropertyUtil;

public class MessageSendFilter extends AccessControlFilter {
	private static final long DEFAULT_EXPIRED = 3000000L;
	private Logger logger = LoggerFactory.getLogger(MessageSendFilter.class);

	protected boolean isAccessAllowed(ServletRequest paramServletRequest, ServletResponse paramServletResponse,Object paramObject) throws Exception {
		return false;
	}

	protected boolean onAccessDenied(ServletRequest paramServletRequest, ServletResponse paramServletResponse) throws Exception {
		if ((paramServletRequest instanceof HttpServletRequest)) {
			HttpServletRequest httpReq = (HttpServletRequest) paramServletRequest;
			String sign = httpReq.getHeader("sign");
			String appid = httpReq.getHeader("appId");
			if (StringUtils.isEmpty(sign)) {
				sign = httpReq.getParameter("sign");
			}
			if (StringUtils.isEmpty(appid)) {
				appid = httpReq.getParameter("appId");
			}

			if ((sign == null) || (appid == null)) {
				HttpServletResponse rp = (HttpServletResponse) paramServletResponse;
				rp.setStatus(400);
				rp.addHeader("Send event message validate error", " 400 , method not allowed, please check called paramaters !");

				rp.getWriter().write("Method not allowed, please check called paramaters !");
				return false;
			}

			String ts = httpReq.getParameter("ts");
			if (StringUtils.isNumeric(ts)) {
				long sendTs = Long.parseLong(ts);
				if (System.currentTimeMillis() - sendTs > DEFAULT_EXPIRED) {
					HttpServletResponse resp = (HttpServletResponse) paramServletResponse;
					resp.setStatus(400);
					resp.addHeader("send message validate error", " 400 ,请求超时");
					resp.getWriter().write(" over time");
					return false;
				}
			}

			boolean passed = ValidatorUrl(httpReq);
			if (!passed) {
				HttpServletResponse rp = (HttpServletResponse) paramServletResponse;
				rp.setStatus(400);
				rp.addHeader("Send event message validate error", " 400 , method not allowed, please check called paramaters !");

				rp.getWriter().write("Method not allowed, please check called paramaters !");
				return false;
			}
			return passed;
		}

		return false;
	}

	private boolean ValidatorUrl(HttpServletRequest httpReq) {
		String sign = httpReq.getHeader("sign");
		String appid = httpReq.getHeader("appId");
		if (StringUtils.isEmpty(sign)) {
			sign = httpReq.getParameter("sign");
		}
		if (StringUtils.isEmpty(appid)) {
			appid = httpReq.getParameter("appId");
		}
		if ((StringUtils.isNotEmpty(sign)) && (StringUtils.isNotEmpty(appid))) {
			try {
				String url = httpReq.getRequestURL().toString();

				if (StringUtils.isNotBlank(httpReq.getQueryString())) {
					url = url + "?" + httpReq.getQueryString();
				}

				String paramterStr = PostParamsHelper.genParamsStrByReqeust(httpReq);

				SignProp prop = SignPropGenerator.genSignProp(url);
				prop.setPostParamsStr(paramterStr);
				prop.setContentLength(httpReq.getContentLength());

				MsgServerVirifyFactory factory = new MsgServerVirifyFactory();
				return factory.getVerifier(appid).verify(sign, prop);
			} catch (UAPSecurityException e) {
				this.logger.error(e.getMessage(), e);
			} catch (MalformedURLException e1) {
				this.logger.error(e1.getMessage(), e1);
			}
		}
		return false;
	}

	class MsgServerVirifyFactory extends ServerVerifyFactory {
		MsgServerVirifyFactory() {}

		protected Credential genCredential(String paramString) {
			try {
				return ClientCredentialGenerator.loadCredential(PropertyUtil.getPropertyByKey("msg.client.credential.path"));
			} catch (UAPSecurityException e) {
				MessageSendFilter.this.logger.error(e.getMessage(), e);
			}
			return null;
		}

		public Verifier getVerifier(String appId) throws UAPSecurityException {
			String signAlg = MsgPropertyUtil.getInnerPropertyByKey("UAP.AUTH.ALG");
			if ("HMAC".equals(signAlg))
				return new MsgDigestVerifier(genCredential(appId));
			if ("RSA".equals(signAlg)) {
				return new RSAServerVerfier(genCredential(appId));
			}
			throw new UAPSecurityException("签名算法" + signAlg + "不匹配!");
		}
	}
}