package com.yonyou.message.center.service;

import com.yonyou.message.center.util.MessageHttpClient;
import com.yyjz.icop.mq.common.MqMessage;
import com.yyjz.icop.mq.consumer.BaseConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by yangmiao on 2016/12/15.
 */
@Component
public class AutoPushMsgListener extends BaseConsumer {
    @Value("${messageUrl}")
    private String url;

    private static Logger logger = LoggerFactory.getLogger(AutoPushMsgListener.class);

    private static final String message_queue_name = "icop-message-queue-auto";

    @Override
    public String[] getQueueNames() {
        return new String[]{message_queue_name};
    }

    @Override
    protected void doConsumeMsg(MqMessage mqMessage) {
        try{

            Map<String,String> params = new HashMap<>() ;
            params.put("data",String.valueOf(mqMessage.getBody()));

            String back = MessageHttpClient.post(url,params);
            logger.info(back);
        }catch(Exception ex){
            logger.error("推送消费失败：",ex);
        }
    }
}
