package com.yonyou.message.center.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSON;
import com.yonyou.message.center.entity.EasemobContent;
import com.yonyou.message.center.util.ContextUtils;
import com.yonyou.uap.entity.content.MessageContent;
import com.yonyou.uap.entity.response.MessageResponse;
import com.yonyou.uap.msg.persistence.service.IMsgTypeService;
import com.yonyou.uap.msg.persistence.service.impl.MsgTypeServiceImpl;
import com.yonyou.uap.service.IMessageSendChannelExt;
import com.yonyou.uap.util.JsonHelper;

public class EasemobSend implements IMessageSendChannelExt {

	private static Logger logger = LoggerFactory.getLogger(EasemobSend.class);
	
	@SuppressWarnings("unchecked")
	@Override
	public List<MessageResponse> send(Map<String, Object> senderInfoMap, Object receiver, Object content) {
		logger.info("senderInfoMap=" + senderInfoMap);
		logger.info("receiver=" + JSON.toJSONString(receiver));
		logger.info("content=" + JSON.toJSONString(content));
		List<MessageResponse> messageResponseList = new ArrayList<MessageResponse>();
		String returnMsg = null;
		if (!CollectionUtils.isEmpty(senderInfoMap)) {
			String serviceURL = String.valueOf(senderInfoMap.get("serviceURL"));
			logger.info("serviceURL=" + serviceURL);
			if ((content instanceof MessageContent)) {
				MessageContent messageContent = (MessageContent) content;
				EasemobContent easemobContent = new EasemobContent(messageContent.getTitle(),
						messageContent.getContent());
				Map<String, Object> origin = messageContent.getOrigin();
				if (origin != null) {
					List<String> target = new ArrayList<String>();
//					String msgtype = (String) origin.get("msgtype");
					IMsgTypeService msgTypeService = (IMsgTypeService) ContextUtils.getBeanByClass(MsgTypeServiceImpl.class);
					logger.info("msgTypeService=" + msgTypeService);
//					MsgTypeEntity msgTypeEntity = msgTypeService.queryMsgTypeByCode(msgtype);
					String from = String.valueOf(origin.get("sendman"));
					Map<String, String> userCodeMap = (Map<String, String>) origin.get("userCodeMap");
					Set<Map.Entry<String, String>> entryseSet = userCodeMap.entrySet();
					for (Map.Entry<String, String> entry : entryseSet) {
						target.add(entry.getValue());
					}
					
					Map<String, Object> params = (Map<String, Object>) origin.get("params");
					setEasemobContentExt(params, easemobContent);
					easemobContent.setFrom(from);
					easemobContent.setTarget(target);
				}
				String json = combineJSON(easemobContent);
				logger.info("json=" + json);
				returnMsg = sendHttpPost(serviceURL, json);
			}
		}
		String flag = JsonHelper.getAttributeValue(returnMsg, "flag");
		String desc = JsonHelper.getAttributeValue(returnMsg, "desc");
		MessageResponse response = new MessageResponse("0".equals(flag)?"1":"0", desc);
		messageResponseList.add(response);
		return messageResponseList;
	}

	private String combineJSON(EasemobContent easemobContent) {
		JSONObject httpJson = new JSONObject();
		try {
			// 消息内容
			httpJson.put("msg", easemobContent.getContent());
			// 消息来源 固定值 应用的名字即可
			httpJson.put("from", easemobContent.getFrom());
			// 消息接收用户编号 json数组，可以对用户
			JSONArray jArr = new JSONArray(Arrays.toString(easemobContent.getTarget().toArray()));
			httpJson.put("target", jArr);
			// 应用ID
			httpJson.put("appid", easemobContent.getAppid());
			httpJson.put("redirect", easemobContent.getRedirect());
			httpJson.put("msgtype", easemobContent.getMsgtype());
			httpJson.put("target_type", easemobContent.getTarget_type());
			httpJson.put("url", easemobContent.getUrl());

			if (!StringUtils.isEmpty(easemobContent.getFileContent())) {
				httpJson.put("fileContent", easemobContent.getFileContent());
			}
			if (!StringUtils.isEmpty(easemobContent.getPicdesc())) {
				httpJson.put("picdesc", easemobContent.getPicdesc());
			}
			if (!StringUtils.isEmpty(easemobContent.getWidth())) {
				httpJson.put("width", easemobContent.getWidth());
			}
			if (!StringUtils.isEmpty(easemobContent.getHeight())) {
				httpJson.put("height", easemobContent.getHeight());
			}
			if (CollectionUtils.isEmpty(easemobContent.getExt())) {
				Map<String, Object> map = easemobContent.getExt();
				JSONObject jsonObejct = new JSONObject(map);
				httpJson.put("ext", jsonObejct);
			}
		} catch (JSONException e) {
			e.printStackTrace();
		}
		String json = httpJson.toString();
		return json;
	}

	@SuppressWarnings("deprecation")
	private String sendHttpPost(String serviceURL, String json) {
		String callback = null;
		try {
			HttpPost httpPost = new HttpPost(serviceURL);
			List<NameValuePair> list = new ArrayList<NameValuePair>();
			list.add(new BasicNameValuePair("params", json));
			UrlEncodedFormEntity postEntity;
			postEntity = new UrlEncodedFormEntity(list, "UTF-8");
			httpPost.setEntity(postEntity);
			@SuppressWarnings("resource")
			DefaultHttpClient httpClient = new DefaultHttpClient();
			HttpResponse response = httpClient.execute(httpPost);
			callback = EntityUtils.toString(response.getEntity(), "UTF-8");
			int status = response.getStatusLine().getStatusCode();
			logger.info("callback=" + callback);
			logger.info("status=" + status);
			if (status != 200) {
				logger.info("发送移动消息提醒失败！");
			} else {
				logger.info("发送移动消息提醒成功！");
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return callback;
	}

	@SuppressWarnings("unchecked")
	private void setEasemobContentExt(Map<String, Object> params, EasemobContent easemobContent) {
		if (CollectionUtils.isEmpty(params)) {
			params = new HashMap<String,Object>();
		}
		if (params.get("msgtype") != null) {
			easemobContent.setMsgtype(String.valueOf(params.get("msgtype")));
		} else {
			easemobContent.setMsgtype("0");
		}
		if (params.get("target_type") != null) {
			easemobContent.setTarget_type(String.valueOf(params.get("target_type")));
		} else {
			easemobContent.setTarget_type("users");
		}
		if (params.get("appid") != null) {
			easemobContent.setAppid(String.valueOf(params.get("appid")));
		} else {
			easemobContent.setAppid("xyd");
		}
		if (params.get("redirect") != null) {
			easemobContent.setRedirect(String.valueOf(params.get("redirect")));
		} else {
			easemobContent.setRedirect("1");
		}
		if (params.get("url") != null) {
			easemobContent.setUrl(String.valueOf(params.get("url")));
		}
		if (params.get("fileContent") != null) {
			easemobContent.setFileContent(String.valueOf(params.get("fileContent")));
		}
		if (params.get("picdesc") != null) {
			easemobContent.setPicdesc(String.valueOf(params.get("picdesc")));
		}
		if (params.get("width") != null) {
			easemobContent.setWidth(String.valueOf(params.get("width")));
		}
		if (params.get("height") != null) {
			easemobContent.setHeight(String.valueOf(params.get("height")));
		}
		if (params.get("ext") != null) {
			Map<String, Object> map = (Map<String, Object>) params.get("ext");
			easemobContent.setExt(map);
		}
	}

}
