package com.yonyou.message.center.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yonyou.iuap.generic.adapter.InvocationInfoProxyAdapter;
import com.yonyou.uap.entity.content.MessageContent;
import com.yonyou.uap.entity.receiver.MessageReceiver;
import com.yonyou.uap.entity.response.MessageResponse;
import com.yonyou.uap.exception.MessageSendException;
import com.yonyou.uap.message.entity.MsgChannel;
import com.yonyou.uap.message.service.IMessageChannel;
import com.yonyou.uap.message.utils.WebPushUtil;
import com.yonyou.uap.msg.persistence.service.IMessageService;
import com.yonyou.uap.msg.persistence.service.IUserInfoService;
import com.yonyou.uap.msg.template.entity.MessageEntity;
import com.yonyou.uap.msg.template.service.IMsgTemplateCreate;
import com.yonyou.uap.msg.template.service.impl.MsgTemplateDefaultBusiVarImpl;
import com.yonyou.uap.service.MessageSend;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@SuppressWarnings("unchecked")
@Service
public class MessageSendSdk {
	private static final Logger logger = LoggerFactory.getLogger(MessageSendSdk.class);

	@Autowired
	private IMsgTemplateCreate msgTemplateCreate;

	@Autowired
	private MsgPersisrenceSdk msgPersistenceSdk;

	@Autowired
	private IUserInfoService userInfoService;

	@Autowired
	private IMessageChannel msgChannelService;

	@Autowired
	private IMessageService msgService;

	public Map<String, Object> pushTemplateMessage(String jsonString) {
		Map<String,Object> returnMap = new HashMap<String,Object>();
		Map<String,Object> dataMap = null;
		String templateCode = null;
		try {
			dataMap = (Map<String,Object>) new ObjectMapper().readValue(jsonString, HashMap.class);
		} catch (IOException e) {
			logger.error("JSON转换成Map时出错，jsonString : " + jsonString, e);
			returnMap.put("msg", "传入的参数格式有误，不是一个标准的JSON字符串。Parameter : " + jsonString);
			returnMap.put("status", Integer.valueOf(0));
			return returnMap;
		}

		try {
			templateCode = dataMap.get("templateCode").toString();
		} catch (NullPointerException e) {
			logger.error("缺少必要的参数", e);
			returnMap.put("msg", "缺少必要的参数。Parameter : " + jsonString);
			returnMap.put("status", Integer.valueOf(0));
			return returnMap;
		}

		MessageEntity msgEntity = null;
		try {
			Map<String, Object> busiDataMap = (Map<String, Object>) dataMap.get("busiData");
			msgEntity = this.msgTemplateCreate.createMessageByCode(templateCode,new MsgTemplateDefaultBusiVarImpl(busiDataMap));
		} catch (Exception e) {
			logger.error("创建消息实体失败", e);
			returnMap.put("msg", "创建消息实体失败。busiData : " + dataMap.get("busiData"));
			returnMap.put("status", Integer.valueOf(0));
			return returnMap;
		}

		MessageContent msgContent = new MessageContent(msgEntity.getMsgTitle(), msgEntity.getMsgContent(), dataMap);

		dataMap.put("subject", msgContent.getTitle());
		dataMap.put("content", msgContent.getContent());
		String tenantId = getTenantId();
		if (org.apache.commons.lang.StringUtils.isNotBlank(tenantId)) {
			dataMap.put("tenantid", tenantId);
		}

		returnMap = sendAndSaveMessage(dataMap, msgContent);
		return returnMap;
	}

	public Map<String, Object> pushTextMessage(String jsonString) {
		Map<String, Object> returnMap = new HashMap<String, Object>();
		Map<String, Object> dataMap = null;

		String subject = null;
		String content = null;
		try {
			dataMap = (Map<String, Object>) new ObjectMapper().readValue(jsonString, HashMap.class);
		} catch (IOException e) {
			logger.error("JSON转换成Map时出错，jsonString : " + jsonString, e);
			returnMap.put("msg", "传入的参数格式有误，不是一个标准的JSON字符串。Parameter : " + jsonString);
			returnMap.put("status", Integer.valueOf(0));
			return returnMap;
		}

		try {
			subject = dataMap.get("subject").toString();
			content = dataMap.get("content").toString();
		} catch (NullPointerException e) {
			logger.error("缺少必要的参数", e);
			returnMap.put("msg", "缺少必要的参数。Parameter : " + jsonString);
			returnMap.put("status", Integer.valueOf(0));
			return returnMap;
		}

		MessageContent msgContent = new MessageContent(subject, content, dataMap);

		String tenantId = getTenantId();
		if (org.apache.commons.lang.StringUtils.isNotBlank(tenantId)) {
			dataMap.put("tenantid", tenantId);
		}

		returnMap = sendAndSaveMessage(dataMap, msgContent);
		return returnMap;
	}

	private Map<String, Object> sendAndSaveMessage(Map<String, Object> dataMap, MessageContent msgContent) {
		Map<String,Object> returnMap = new HashMap<String,Object>();
		List<String> channelCodeList = (List<String>) dataMap.get("channel");
		List<MsgChannel> channelList = this.msgChannelService.queryMsgChannelByCodes(channelCodeList);
		ArrayList<String> receiversArr = (ArrayList<String>) dataMap.get("recevier");
		Boolean isOnlySys = true;
		for(String str : channelCodeList) {
			if(!"sys".equals(str)) {
				isOnlySys = false;
			}
		}
		
		Map<String,Map<String,String>> map = null;
		if ((receiversArr != null) && (receiversArr.size() > 0)) {
			List<String> allReceiver = mergeAllReceiver(receiversArr, dataMap);
			try {
				map = this.userInfoService.getUserMobileEmailMap((String[]) allReceiver.toArray(new String[0]));
				Map<String,String> userMobileMap = (Map<String,String>) map.get("userMobileMap");
				Map<String,String> userEmailMap = (Map<String,String>) map.get("userEmailMap");
				Map<String,String> userCodeMap = (Map<String,String>) map.get("userCodeMap");
				
				dataMap.put("userCodeMap", userCodeMap);
				dataMap.put("userMobileMap", userMobileMap);
				dataMap.put("userEmailMap", userEmailMap);
			} catch (Throwable e) {
				logger.error("查询用户信息异常",e);
				if(!isOnlySys) {
					e.printStackTrace();
				}
			}
		} else {
			dataMap.put("recevier", new ArrayList<String>());
			dataMap.put("userMobileMap", new HashMap<String,String>());
			dataMap.put("userEmailMap", new HashMap<String,String>());
		}

		String messageId = this.msgPersistenceSdk.saveMessage(dataMap);

		List<MessageResponse> responseAllList = new ArrayList<MessageResponse>();
		for (MsgChannel msgChannel : channelList) {
			this.msgPersistenceSdk.saveReceivers(messageId, msgChannel.getType(), dataMap);

			if (!"sys".equals(msgChannel.getType())) {
				String receiversStr = buildReceiverString(msgChannel, receiversArr, map, dataMap);
				MessageReceiver msgReceiver = new MessageReceiver(receiversStr);

				List<MessageResponse> responseList = null;
				try {
					responseList = new MessageSend(msgReceiver, msgContent, msgChannel.getCode()).send();
				} catch (MessageSendException e) {
					logger.error("消息发送时发生异常。", e);
					returnMap.put("msg", "消息发送时发生异常。");
					returnMap.put("status", Integer.valueOf(0));
					return returnMap;
				}
				
				List<String> receiverList = new ArrayList<String>();
				if (("mail".equals(msgChannel.getType())) && (map != null)) {
					Map<String, String> emailUserMap = (Map<String, String>) map.get("emailUserMap");
					receiverList = buildUserList(responseList, emailUserMap);
					if ((receiverList != null) && (receiverList.size() > 0)) {
						receiverList = buildMailUserList(receiverList, dataMap);
					}
				}
				if (("sms".equals(msgChannel.getType())) && (map != null)) {
					Map<String, String> mobileUserMap = (Map<String, String>) map.get("mobileUserMap");
					receiverList = buildUserList(responseList, mobileUserMap);
				}
				if ((receiverList != null) && (receiverList.size() > 0)) {
					this.msgPersistenceSdk.updateRecevierStatus(receiverList, messageId, "0");
				}
				List<MessageResponse> transResponseList = transLateResponse(responseList, msgChannel);
				responseAllList.addAll(transResponseList);
			} else {
				String params = buildParams(dataMap);
				try {
					if (null != params) {
						WebPushUtil.webPush(params);
						returnMap.put("webpushMsg", "消息推送成功");
					}
				} catch (IOException e) {
					logger.error(e.getMessage(), e);
					returnMap.put("webpushMsg", "消息推送失败");
				}
			}
		}

		returnMap.put("msgList", responseAllList);
		int status = calculateStatusByResponse(responseAllList);
		returnMap.put("status", Integer.valueOf(status));
		String msg = null;
		if (status == 0)
			msg = "消息发送失败";
		else if (status == 1)
			msg = "消息发送成功";
		else {
			msg = "消息发送部分成功";
		}

		returnMap.put("msg", msg);
		return returnMap;
	}

	private List<MessageResponse> transLateResponse(List<MessageResponse> responseList, MsgChannel msgChannel) {
		List<MessageResponse> list = new ArrayList<MessageResponse>();
		for (MessageResponse msgResponse : responseList) {
			String code = msgResponse.getResponseStatusCode();
			if (("mail".equals(msgChannel.getType())) || ("sms".equals(msgChannel.getType()))) {
				if ("0".equals(msgResponse.getResponseStatusCode()))
					code = "1";
				else if ("1".equals(msgResponse.getResponseStatusCode())) {
					code = "0";
				}
			}
			String content = msgResponse.getResponseContent();
			MessageResponse response = new MessageResponse(code, content);
			response.setReceiver(msgResponse.getReceiver());
			list.add(response);
		}
		return list;
	}

	private int calculateStatusByResponse(List<MessageResponse> responseAllList) {
		int status = 1;

		boolean hasSuccess = false;
		boolean hasFailed = false;
		boolean allSuccess = true;

		int successCount = 0;
		for (MessageResponse msgResponse : responseAllList) {
			if ("1".equals(msgResponse.getResponseStatusCode())) {
				hasSuccess = true;
				successCount++;
			} else {
				hasFailed = true;
			}
		}
		if (successCount != responseAllList.size()) {
			allSuccess = false;
		}
		if (allSuccess)
			status = 1;
		else if ((hasSuccess) && (hasFailed))
			status = 2;
		else {
			status = 0;
		}
		return status;
	}

	private List<String> buildMailUserList(List<String> receiverList, Map<String, Object> dataMap) {
		List<String> mailCcReceiver = (List<String>) dataMap.get("mailCcIds");
		List<String> mailBccReceiver = (List<String>) dataMap.get("mailBccIds");

		if ((null != mailCcReceiver) && (mailCcReceiver.size() > 0) && (null != mailBccReceiver)
				&& (mailBccReceiver.size() > 0)) {
			mailCcReceiver.removeAll(mailBccReceiver);
		}
		if ((null != mailCcReceiver) && (mailCcReceiver.size() > 0)) {
			for (String receiver : mailCcReceiver) {
				if (org.apache.commons.lang3.StringUtils.isNotBlank(receiver)) {
					receiverList.add(receiver);
				}
			}
		}
		if ((null != mailBccReceiver) && (mailBccReceiver.size() > 0)) {
			for (String receiver : mailBccReceiver) {
				if (org.apache.commons.lang3.StringUtils.isNotBlank(receiver)) {
					receiverList.add(receiver);
				}
			}
		}

		String mailCcAddressReceiver = (String) dataMap.get("mailCc");
		String mailBccAddressReceiver = (String) dataMap.get("mailBcc");
		List<String> mailCcAddressList = new ArrayList<String>();
		List<String> mailBccAddressList = new ArrayList<String>();
		if (org.apache.commons.lang.StringUtils.isNotBlank(mailCcAddressReceiver)) {
			mailCcAddressList = Arrays.asList(mailCcAddressReceiver.split(","));
		}
		if (org.apache.commons.lang.StringUtils.isNotBlank(mailBccAddressReceiver)) {
			mailBccAddressList = Arrays.asList(mailBccAddressReceiver.split(","));
		}
		if ((null != mailCcAddressList) && (mailCcAddressList.size() > 0) && (null != mailBccAddressList)
				&& (mailBccAddressList.size() > 0)) {
			mailCcAddressList.removeAll(mailBccAddressList);
		}
		if ((null != mailCcAddressList) && (mailCcAddressList.size() > 0)) {
			for (String receiver : mailCcAddressList) {
				if (org.apache.commons.lang3.StringUtils.isNotBlank(receiver)) {
					receiverList.add(receiver);
				}
			}
		}
		if ((null != mailBccAddressList) && (mailBccAddressList.size() > 0)) {
			for (String receiver : mailBccAddressList) {
				if (org.apache.commons.lang3.StringUtils.isNotBlank(receiver)) {
					receiverList.add(receiver);
				}
			}
		}
		return receiverList;
	}

	private List<String> mergeAllReceiver(ArrayList<String> receiversArr, Map<String, Object> dataMap) {
		List<String> allReceiverList = new ArrayList<String>();
		List<String> mailCcReceiver = (List<String>) dataMap.get("mailCcIds");
		List<String> mailBccReceiver = (List<String>) dataMap.get("mailBccIds");

		if ((null != receiversArr) && (receiversArr.size() > 0)) {
			for (String receiver : receiversArr) {
				if ((org.apache.commons.lang3.StringUtils.isNotBlank(receiver))
						&& (!allReceiverList.contains(receiver))) {
					allReceiverList.add(receiver);
				}
			}
		}
		if ((null != mailCcReceiver) && (mailCcReceiver.size() > 0)) {
			for (String receiver : mailCcReceiver) {
				if ((org.apache.commons.lang3.StringUtils.isNotBlank(receiver))
						&& (!allReceiverList.contains(receiver))) {
					allReceiverList.add(receiver);
				}
			}
		}
		if ((null != mailBccReceiver) && (mailBccReceiver.size() > 0)) {
			for (String receiver : mailBccReceiver) {
				if ((org.apache.commons.lang3.StringUtils.isNotBlank(receiver))
						&& (!allReceiverList.contains(receiver))) {
					allReceiverList.add(receiver);
				}
			}
		}
		return allReceiverList;
	}

	private String buildParams(Map<String, Object> dataMap) {
		Object tenantIdObj = dataMap.get("tenantid");
		Map<String,Object> searchMap = new HashMap<String,Object>();
		String tenantid = null;
		if (null != tenantIdObj) {
			tenantid = String.valueOf(tenantIdObj);
			searchMap.put("tenantid", tenantid);
		}
		List<String> userKeys = new ArrayList<String>();
		List<String> receiverList = new ArrayList<String>();
		ArrayList<String> receiversArr = (ArrayList<String>) dataMap.get("recevier");
		for (String receiver : receiversArr) {
			userKeys.add(tenantid + "_" + receiver);
			receiverList.add(receiver);
		}
		searchMap.put("receiverList", receiverList);

		if (userKeys.size() > 0) {
			List<Map<String,Object>> unreadMsgNumMap = this.msgService.getUnReadMsgNumBatch(searchMap);
			Map<String,Object> receiverMap = new HashMap<String,Object>();
			if (null != unreadMsgNumMap) {
				for (Map<String,Object> msgNumMap : unreadMsgNumMap) {
					String receiver = (String) msgNumMap.get("receiver");
					int count = Integer.valueOf(String.valueOf(msgNumMap.get("count"))).intValue();
					receiverMap.put(tenantid + "_" + receiver, Integer.valueOf(count));
				}
			}
			Map<String,Object> paramMap = new HashMap<String,Object>();
			paramMap.put("identity", "server1001");
			paramMap.put("userkeys", userKeys);
			paramMap.put("message", receiverMap);
			JSONObject jsonObj = JSONObject.fromObject(paramMap);
			String params = jsonObj.toString();
			return params;
		}
		return null;
	}

	private List<String> buildUserList(List<MessageResponse> responseList, Map<String, String> userMap) {
		List<String> receiverList = new ArrayList<String>();
		for (MessageResponse msgResponse : responseList) {
			if (!"0".equals(msgResponse.getResponseStatusCode())) {
				String address = msgResponse.getReceiver();
				if (org.apache.commons.lang.StringUtils.isNotBlank(address)) {
					String userId = (String) userMap.get(address);
					if (org.apache.commons.lang.StringUtils.isNotBlank(userId))
						receiverList.add(userId);
					else
						receiverList.add(address);
				}
			}
		}
		return receiverList;
	}

	private String buildReceiverString(MsgChannel msgChannel, ArrayList<String> receiversArr,Map<String, Map<String, String>> map, Map<String, Object> params) {
		String channelType = msgChannel.getType();
		Map<String, String> mapUserInfo = null;
		if ("mail".equals(channelType)) {
			if (map != null)
				mapUserInfo = (Map<String, String>) map.get("userEmailMap");
		} else if ("sms".equals(channelType)) {
			if (map != null)
				mapUserInfo = (Map<String, String>) map.get("userMobileMap");
		} else {
			if ((receiversArr != null) && (receiversArr.size() > 0)) {
				return org.apache.commons.lang.StringUtils.join(receiversArr, ",");
			}
			return null;
		}

		List<String> externalReceiver = (List<String>) params.get(channelType + "Receiver");
		if (externalReceiver == null) {
			externalReceiver = new ArrayList<String>();
		}
		if (mapUserInfo == null) {
			if (externalReceiver.size() == 0)
				return null;
			return org.apache.commons.lang.StringUtils.join(externalReceiver, ",");
		}
		List<String> sysReceiver = new ArrayList<String>();
		for (int i = 0; i < receiversArr.size(); i++) {
			String email = (String) mapUserInfo.get(receiversArr.get(i));
			if (!org.apache.commons.lang.StringUtils.isBlank(email)) {
				sysReceiver.add(email);
			}
		}
		externalReceiver.removeAll(sysReceiver);
		if ((null != externalReceiver) && (externalReceiver.size() > 0)) {
			for (String receiver : externalReceiver) {
				if (org.apache.commons.lang3.StringUtils.isNotBlank(receiver)) {
					sysReceiver.add(receiver);
				}
			}
		}
		return org.apache.commons.lang.StringUtils.join(sysReceiver, ",");
	}

	private String getTenantId() {
		String tenantId = null;

		if (org.apache.commons.lang.StringUtils.isEmpty(tenantId)) {
			tenantId = InvocationInfoProxyAdapter.getTenantid();
		}
		return tenantId;
	}
}