package com.yonyou.message.center.service.impl;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.yonyou.message.center.entity.PushMsgParameter;
import com.yonyou.message.center.service.PushMsgService;
import com.yyjz.icop.mq.common.MqMessage;
import com.yyjz.icop.mq.sender.MsgSender;

/**
 * Created by yangmiao on 2016/12/9.
 */
@Service("pushMsgService")
public class PushMsgServiceImpl implements PushMsgService{

    private static Logger logger = LoggerFactory.getLogger(PushMsgServiceImpl.class);

    private static final String message_queue_name = "icop-message-queue";

    @Autowired(required=false)
    private MsgSender msgSender;

    @Override
    public String pushMessage(PushMsgParameter msgParameter) {
        try{
            MqMessage mqMessage = new MqMessage();
            mqMessage.setBody(msgParameter);
            String queueName = StringUtils.isNotBlank(msgParameter.getQueueName()) ? msgParameter.getQueueName() : message_queue_name;
            msgSender.sendMessage(mqMessage, queueName);
        }catch (Exception e){
            logger.error("消息推送失败：",e);
            return "{\"success\":false}";
        }
        return "{\"success\":true}";
    }
}
