package com.yonyou.message.center.util;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/**
 * spring应用上下文工具类 该类必须注入到springmvc.xml中，否则applicationContext会得不到值
 */
// @Component
public class ContextUtils implements ApplicationContextAware {
	private static ApplicationContext applicationContext; // 应用上下文对象

	@Override
	public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
		ContextUtils.applicationContext = applicationContext;
	}
	//提供一个接口，获取容器中的Bean实例，根据名称获取
	public static <T> T getBean(String beanName, Class<T> clazz) {
		return applicationContext.getBean(beanName, clazz);
	}

	public static Object getBeanByClass(Class c) {
		return applicationContext.getBean(c);
	}

}
