package com.yonyou.sms.util;

import java.util.ArrayList;
import java.util.List;

import com.yonyou.sms.model.content.SMSContent;
import com.yonyou.sms.service.impl.SMSSend;

public class MessageSend {
	
	private MessageReceiver receivers;
	private MessageContent content;

	public MessageSend(MessageReceiver msgReceivers, MessageContent msgContent) {
		this.receivers = msgReceivers;
		this.content = msgContent;
	}

	public List<MessageResponse> send() {
		List<MessageResponse> responseList = new ArrayList<MessageResponse>();

//		if ((this.content instanceof EmailContent)) {
//			EMailSend eamilSend = EMailSend.initialization();
//			EmailContent eamilContent = (EmailContent) this.content;
//
//			String[] emailAddressArray = this.receivers.getReceiverAddress().split(",");
//
//			for (int i = 0; i < emailAddressArray.length; i++) {
//				String emailAddress = emailAddressArray[i];
//				responseList.add(eamilSend.send(emailAddress, eamilContent));
//			}
//
//		} else 
		if ((this.content instanceof SMSContent)) {
			SMSSend sms = SMSSend.initialization();
			SMSContent smsContent = (SMSContent) this.content;

			String[] mobileNumberArray = this.receivers.getReceiverAddress().split(",");

			for (int i = 0; i < mobileNumberArray.length; i++) {
				String mobileNumber = mobileNumberArray[i];
				responseList.add(sms.send(mobileNumber, smsContent));
			}

		}

		return responseList;
	}

	public static void main(String[] args) {
		MessageReceiver msgReceivers = new MessageReceiver("15222476920");
		MessageContent msgContent = new SMSContent("title", "下班了", 0);

		List<MessageResponse> responseList = new MessageSend(msgReceivers, msgContent).send();

		System.out.println(responseList.get(0));
	}
}