package com.yonyou.uap.message.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.yonyou.uap.entity.content.EmailContent;
import com.yonyou.uap.entity.content.MessageContent;
import com.yonyou.uap.entity.receiver.EmailReceiver;
import com.yonyou.uap.entity.receiver.MessageReceiver;
import com.yonyou.uap.entity.response.MessageResponse;
import com.yonyou.uap.exception.MessageSendException;
import com.yonyou.uap.service.MessageSend;

@Controller
@RequestMapping({ "/msgSendTest/" })
public class MessageSendTestController {
	@RequestMapping(method = { org.springframework.web.bind.annotation.RequestMethod.GET }, value = { "/test/{code}" })
	@ResponseBody
	public Object queryMsgChannel(@PathVariable("code") String code) throws MessageSendException {
		Map<String,List<MessageResponse>> returnMap = new HashMap<String,List<MessageResponse>>();

		MessageReceiver msgReceiver = new EmailReceiver("taomaokun@foxmail.com");
		MessageContent msgContent = new EmailContent("I am title!", "For test!");

		MessageSend messageSend = new MessageSend(msgReceiver, msgContent, code);

		returnMap.put("data", messageSend.send());

		return returnMap;
	}
}